/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetKeyPairsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetKeyPairsRequest.Builder, GetKeyPairsRequest> {
    private final String pageToken;

    private GetKeyPairsRequest(BuilderImpl builder) {
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get key pairs request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get key pairs request.
     */
    public String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((pageToken() == null) ? 0 : pageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyPairsRequest)) {
            return false;
        }
        GetKeyPairsRequest other = (GetKeyPairsRequest) obj;
        if (other.pageToken() == null ^ this.pageToken() == null) {
            return false;
        }
        if (other.pageToken() != null && !other.pageToken().equals(this.pageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (pageToken() != null) {
            sb.append("PageToken: ").append(pageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetKeyPairsRequest> {
        /**
         * <p>
         * A token used for advancing to the next page of results from your get key pairs request.
         * </p>
         * 
         * @param pageToken
         *        A token used for advancing to the next page of results from your get key pairs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);
    }

    private static final class BuilderImpl implements Builder {
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyPairsRequest model) {
            setPageToken(model.pageToken);
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public GetKeyPairsRequest build() {
            return new GetKeyPairsRequest(this);
        }
    }
}
