/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetKeyPairsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetKeyPairsResponse.Builder, GetKeyPairsResponse> {
    private final List<KeyPair> keyPairs;

    private final String nextPageToken;

    private GetKeyPairsResponse(BuilderImpl builder) {
        this.keyPairs = builder.keyPairs;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the key pairs.
     */
    public List<KeyPair> keyPairs() {
        return keyPairs;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get key pairs request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get key pairs request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyPairs() == null) ? 0 : keyPairs().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyPairsResponse)) {
            return false;
        }
        GetKeyPairsResponse other = (GetKeyPairsResponse) obj;
        if (other.keyPairs() == null ^ this.keyPairs() == null) {
            return false;
        }
        if (other.keyPairs() != null && !other.keyPairs().equals(this.keyPairs())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyPairs() != null) {
            sb.append("KeyPairs: ").append(keyPairs()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetKeyPairsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the key pairs.
         * </p>
         * 
         * @param keyPairs
         *        An array of key-value pairs containing information about the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(Collection<KeyPair> keyPairs);

        /**
         * <p>
         * An array of key-value pairs containing information about the key pairs.
         * </p>
         * 
         * @param keyPairs
         *        An array of key-value pairs containing information about the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(KeyPair... keyPairs);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get key pairs request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get key pairs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<KeyPair> keyPairs;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyPairsResponse model) {
            setKeyPairs(model.keyPairs);
            setNextPageToken(model.nextPageToken);
        }

        public final Collection<KeyPair> getKeyPairs() {
            return keyPairs;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPair> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPair... keyPairs) {
            keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPair> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetKeyPairsResponse build() {
            return new GetKeyPairsResponse(this);
        }
    }
}
