/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.InstanceHardwareMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the hardware for the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceHardware implements StructuredPojo, ToCopyableBuilder<InstanceHardware.Builder, InstanceHardware> {
    private final Integer cpuCount;

    private final List<Disk> disks;

    private final Float ramSizeInGb;

    private InstanceHardware(BuilderImpl builder) {
        this.cpuCount = builder.cpuCount;
        this.disks = builder.disks;
        this.ramSizeInGb = builder.ramSizeInGb;
    }

    /**
     * <p>
     * The number of vCPUs the instance has.
     * </p>
     * 
     * @return The number of vCPUs the instance has.
     */
    public Integer cpuCount() {
        return cpuCount;
    }

    /**
     * <p>
     * The disks attached to the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The disks attached to the instance.
     */
    public List<Disk> disks() {
        return disks;
    }

    /**
     * <p>
     * The amount of RAM in GB on the instance (e.g., <code>1.0</code>).
     * </p>
     * 
     * @return The amount of RAM in GB on the instance (e.g., <code>1.0</code>).
     */
    public Float ramSizeInGb() {
        return ramSizeInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cpuCount() == null) ? 0 : cpuCount().hashCode());
        hashCode = 31 * hashCode + ((disks() == null) ? 0 : disks().hashCode());
        hashCode = 31 * hashCode + ((ramSizeInGb() == null) ? 0 : ramSizeInGb().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHardware)) {
            return false;
        }
        InstanceHardware other = (InstanceHardware) obj;
        if (other.cpuCount() == null ^ this.cpuCount() == null) {
            return false;
        }
        if (other.cpuCount() != null && !other.cpuCount().equals(this.cpuCount())) {
            return false;
        }
        if (other.disks() == null ^ this.disks() == null) {
            return false;
        }
        if (other.disks() != null && !other.disks().equals(this.disks())) {
            return false;
        }
        if (other.ramSizeInGb() == null ^ this.ramSizeInGb() == null) {
            return false;
        }
        if (other.ramSizeInGb() != null && !other.ramSizeInGb().equals(this.ramSizeInGb())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cpuCount() != null) {
            sb.append("CpuCount: ").append(cpuCount()).append(",");
        }
        if (disks() != null) {
            sb.append("Disks: ").append(disks()).append(",");
        }
        if (ramSizeInGb() != null) {
            sb.append("RamSizeInGb: ").append(ramSizeInGb()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceHardwareMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceHardware> {
        /**
         * <p>
         * The number of vCPUs the instance has.
         * </p>
         * 
         * @param cpuCount
         *        The number of vCPUs the instance has.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCount(Integer cpuCount);

        /**
         * <p>
         * The disks attached to the instance.
         * </p>
         * 
         * @param disks
         *        The disks attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(Collection<Disk> disks);

        /**
         * <p>
         * The disks attached to the instance.
         * </p>
         * 
         * @param disks
         *        The disks attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(Disk... disks);

        /**
         * <p>
         * The amount of RAM in GB on the instance (e.g., <code>1.0</code>).
         * </p>
         * 
         * @param ramSizeInGb
         *        The amount of RAM in GB on the instance (e.g., <code>1.0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramSizeInGb(Float ramSizeInGb);
    }

    private static final class BuilderImpl implements Builder {
        private Integer cpuCount;

        private List<Disk> disks;

        private Float ramSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceHardware model) {
            setCpuCount(model.cpuCount);
            setDisks(model.disks);
            setRamSizeInGb(model.ramSizeInGb);
        }

        public final Integer getCpuCount() {
            return cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Collection<Disk> getDisks() {
            return disks;
        }

        @Override
        public final Builder disks(Collection<Disk> disks) {
            this.disks = DiskListCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Disk... disks) {
            disks(Arrays.asList(disks));
            return this;
        }

        public final void setDisks(Collection<Disk> disks) {
            this.disks = DiskListCopier.copy(disks);
        }

        public final Float getRamSizeInGb() {
            return ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        @Override
        public InstanceHardware build() {
            return new InstanceHardware(this);
        }
    }
}
