/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.OperationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Operation implements StructuredPojo, ToCopyableBuilder<Operation.Builder, Operation> {
    private final String id;

    private final String resourceName;

    private final String resourceType;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final Boolean isTerminal;

    private final String operationDetails;

    private final String operationType;

    private final String status;

    private final Instant statusChangedAt;

    private final String errorCode;

    private final String errorDetails;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.isTerminal = builder.isTerminal;
        this.operationDetails = builder.operationDetails;
        this.operationType = builder.operationType;
        this.status = builder.status;
        this.statusChangedAt = builder.statusChangedAt;
        this.errorCode = builder.errorCode;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The ID of the operation.
     * </p>
     * 
     * @return The ID of the operation.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The resource name.
     * </p>
     * 
     * @return The resource name.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     * @see ResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
     * </p>
     * 
     * @return The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The region and Availability Zone.
     * </p>
     * 
     * @return The region and Availability Zone.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * A Boolean value indicating whether the operation is terminal.
     * </p>
     * 
     * @return A Boolean value indicating whether the operation is terminal.
     */
    public Boolean isTerminal() {
        return isTerminal;
    }

    /**
     * <p>
     * Details about the operation (e.g., <code>Debian-1GB-Virginia-1</code>).
     * </p>
     * 
     * @return Details about the operation (e.g., <code>Debian-1GB-Virginia-1</code>).
     */
    public String operationDetails() {
        return operationDetails;
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * 
     * @return The type of operation.
     * @see OperationType
     */
    public String operationType() {
        return operationType;
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * 
     * @return The status of the operation.
     * @see OperationStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
     * </p>
     * 
     * @return The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
     */
    public Instant statusChangedAt() {
        return statusChangedAt;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * 
     * @return The error code.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error details.
     * </p>
     * 
     * @return The error details.
     */
    public String errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((resourceName() == null) ? 0 : resourceName().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((isTerminal() == null) ? 0 : isTerminal().hashCode());
        hashCode = 31 * hashCode + ((operationDetails() == null) ? 0 : operationDetails().hashCode());
        hashCode = 31 * hashCode + ((operationType() == null) ? 0 : operationType().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusChangedAt() == null) ? 0 : statusChangedAt().hashCode());
        hashCode = 31 * hashCode + ((errorCode() == null) ? 0 : errorCode().hashCode());
        hashCode = 31 * hashCode + ((errorDetails() == null) ? 0 : errorDetails().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.isTerminal() == null ^ this.isTerminal() == null) {
            return false;
        }
        if (other.isTerminal() != null && !other.isTerminal().equals(this.isTerminal())) {
            return false;
        }
        if (other.operationDetails() == null ^ this.operationDetails() == null) {
            return false;
        }
        if (other.operationDetails() != null && !other.operationDetails().equals(this.operationDetails())) {
            return false;
        }
        if (other.operationType() == null ^ this.operationType() == null) {
            return false;
        }
        if (other.operationType() != null && !other.operationType().equals(this.operationType())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusChangedAt() == null ^ this.statusChangedAt() == null) {
            return false;
        }
        if (other.statusChangedAt() != null && !other.statusChangedAt().equals(this.statusChangedAt())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.errorDetails() == null ^ this.errorDetails() == null) {
            return false;
        }
        if (other.errorDetails() != null && !other.errorDetails().equals(this.errorDetails())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (resourceName() != null) {
            sb.append("ResourceName: ").append(resourceName()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (isTerminal() != null) {
            sb.append("IsTerminal: ").append(isTerminal()).append(",");
        }
        if (operationDetails() != null) {
            sb.append("OperationDetails: ").append(operationDetails()).append(",");
        }
        if (operationType() != null) {
            sb.append("OperationType: ").append(operationType()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusChangedAt() != null) {
            sb.append("StatusChangedAt: ").append(statusChangedAt()).append(",");
        }
        if (errorCode() != null) {
            sb.append("ErrorCode: ").append(errorCode()).append(",");
        }
        if (errorDetails() != null) {
            sb.append("ErrorDetails: ").append(errorDetails()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Operation> {
        /**
         * <p>
         * The ID of the operation.
         * </p>
         * 
         * @param id
         *        The ID of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The resource name.
         * </p>
         * 
         * @param resourceName
         *        The resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The region and Availability Zone.
         * </p>
         * 
         * @param location
         *        The region and Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * A Boolean value indicating whether the operation is terminal.
         * </p>
         * 
         * @param isTerminal
         *        A Boolean value indicating whether the operation is terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTerminal(Boolean isTerminal);

        /**
         * <p>
         * Details about the operation (e.g., <code>Debian-1GB-Virginia-1</code>).
         * </p>
         * 
         * @param operationDetails
         *        Details about the operation (e.g., <code>Debian-1GB-Virginia-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationDetails(String operationDetails);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * The status of the operation.
         * </p>
         * 
         * @param status
         *        The status of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the operation.
         * </p>
         * 
         * @param status
         *        The status of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
         * </p>
         * 
         * @param statusChangedAt
         *        The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusChangedAt(Instant statusChangedAt);

        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error details.
         * </p>
         * 
         * @param errorDetails
         *        The error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(String errorDetails);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String resourceName;

        private String resourceType;

        private Instant createdAt;

        private ResourceLocation location;

        private Boolean isTerminal;

        private String operationDetails;

        private String operationType;

        private String status;

        private Instant statusChangedAt;

        private String errorCode;

        private String errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            setId(model.id);
            setResourceName(model.resourceName);
            setResourceType(model.resourceType);
            setCreatedAt(model.createdAt);
            setLocation(model.location);
            setIsTerminal(model.isTerminal);
            setOperationDetails(model.operationDetails);
            setOperationType(model.operationType);
            setStatus(model.status);
            setStatusChangedAt(model.statusChangedAt);
            setErrorCode(model.errorCode);
            setErrorDetails(model.errorDetails);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation getLocation() {
            return location;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public final Boolean getIsTerminal() {
            return isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        public final String getOperationDetails() {
            return operationDetails;
        }

        @Override
        public final Builder operationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
            return this;
        }

        public final void setOperationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
        }

        public final String getOperationType() {
            return operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStatusChangedAt() {
            return statusChangedAt;
        }

        @Override
        public final Builder statusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
            return this;
        }

        public final void setStatusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDetails() {
            return errorDetails;
        }

        @Override
        public final Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }
    }
}
