/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDomainEntryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateDomainEntryResponse.Builder, UpdateDomainEntryResponse> {
    private final List<Operation> operations;

    private UpdateDomainEntryResponse(BuilderImpl builder) {
        this.operations = builder.operations;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the request operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the request operation.
     */
    public List<Operation> operations() {
        return operations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operations() == null) ? 0 : operations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainEntryResponse)) {
            return false;
        }
        UpdateDomainEntryResponse other = (UpdateDomainEntryResponse) obj;
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        if (other.operations() != null && !other.operations().equals(this.operations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (operations() != null) {
            sb.append("Operations: ").append(operations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDomainEntryResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the request operation.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the request operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * An array of key-value pairs containing information about the request operation.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the request operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);
    }

    private static final class BuilderImpl implements Builder {
        private List<Operation> operations;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainEntryResponse model) {
            setOperations(model.operations);
        }

        public final Collection<Operation> getOperations() {
            return operations;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
        }

        @Override
        public UpdateDomainEntryResponse build() {
            return new UpdateDomainEntryResponse(this);
        }
    }
}
