/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.lightsail.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * DomainMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class DomainMarshaller {

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").build();
    private static final MarshallingInfo<java.time.Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<List> DOMAINENTRIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainEntries").build();

    private static final DomainMarshaller INSTANCE = new DomainMarshaller();

    public static DomainMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(Domain domain, ProtocolMarshaller protocolMarshaller) {

        if (domain == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(domain.name(), NAME_BINDING);

            protocolMarshaller.marshall(domain.arn(), ARN_BINDING);

            protocolMarshaller.marshall(domain.supportCode(), SUPPORTCODE_BINDING);

            protocolMarshaller.marshall(domain.createdAt(), CREATEDAT_BINDING);

            protocolMarshaller.marshall(domain.location(), LOCATION_BINDING);

            protocolMarshaller.marshall(domain.resourceType(), RESOURCETYPE_BINDING);

            protocolMarshaller.marshall(domain.domainEntries(), DOMAINENTRIES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
