/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lightsail.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Instance JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceUnmarshaller implements Unmarshaller<Instance, JsonUnmarshallerContext> {

    public Instance unmarshall(JsonUnmarshallerContext context) throws Exception {
        Instance.Builder instanceBuilder = Instance.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.supportCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.createdAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.resourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("blueprintId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.blueprintId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("blueprintName", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.blueprintName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("bundleId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.bundleId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("isStaticIp", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.isStaticIp(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("privateIpAddress", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.privateIpAddress(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("publicIpAddress", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.publicIpAddress(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ipv6Address", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.ipv6Address(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("hardware", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.hardware(InstanceHardwareUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("networking", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.networking(InstanceNetworkingUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.state(InstanceStateUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("username", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.username(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("sshKeyName", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.sshKeyName(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return instanceBuilder.build();
    }

    private static final InstanceUnmarshaller INSTANCE = new InstanceUnmarshaller();

    public static InstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
