/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateInstancesRequest> {
    private final List<String> instanceNames;
    private final String availabilityZone;
    private final String customImageName;
    private final String blueprintId;
    private final String bundleId;
    private final String userData;
    private final String keyPairName;

    private CreateInstancesRequest(BuilderImpl builder) {
        this.instanceNames = builder.instanceNames;
        this.availabilityZone = builder.availabilityZone;
        this.customImageName = builder.customImageName;
        this.blueprintId = builder.blueprintId;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String customImageName() {
        return this.customImageName;
    }

    public String blueprintId() {
        return this.blueprintId;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String userData() {
        return this.userData;
    }

    public String keyPairName() {
        return this.keyPairName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceNames() == null ? 0 : this.instanceNames().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.customImageName() == null ? 0 : this.customImageName().hashCode());
        hashCode = 31 * hashCode + (this.blueprintId() == null ? 0 : this.blueprintId().hashCode());
        hashCode = 31 * hashCode + (this.bundleId() == null ? 0 : this.bundleId().hashCode());
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        hashCode = 31 * hashCode + (this.keyPairName() == null ? 0 : this.keyPairName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesRequest)) {
            return false;
        }
        CreateInstancesRequest other = (CreateInstancesRequest)((Object)obj);
        if (other.instanceNames() == null ^ this.instanceNames() == null) {
            return false;
        }
        if (other.instanceNames() != null && !other.instanceNames().equals(this.instanceNames())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.customImageName() == null ^ this.customImageName() == null) {
            return false;
        }
        if (other.customImageName() != null && !other.customImageName().equals(this.customImageName())) {
            return false;
        }
        if (other.blueprintId() == null ^ this.blueprintId() == null) {
            return false;
        }
        if (other.blueprintId() != null && !other.blueprintId().equals(this.blueprintId())) {
            return false;
        }
        if (other.bundleId() == null ^ this.bundleId() == null) {
            return false;
        }
        if (other.bundleId() != null && !other.bundleId().equals(this.bundleId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.keyPairName() == null ^ this.keyPairName() == null) {
            return false;
        }
        return other.keyPairName() == null || other.keyPairName().equals(this.keyPairName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceNames() != null) {
            sb.append("InstanceNames: ").append(this.instanceNames()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.customImageName() != null) {
            sb.append("CustomImageName: ").append(this.customImageName()).append(",");
        }
        if (this.blueprintId() != null) {
            sb.append("BlueprintId: ").append(this.blueprintId()).append(",");
        }
        if (this.bundleId() != null) {
            sb.append("BundleId: ").append(this.bundleId()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (this.keyPairName() != null) {
            sb.append("KeyPairName: ").append(this.keyPairName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> instanceNames;
        private String availabilityZone;
        private String customImageName;
        private String blueprintId;
        private String bundleId;
        private String userData;
        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesRequest model) {
            this.setInstanceNames(model.instanceNames);
            this.setAvailabilityZone(model.availabilityZone);
            this.setCustomImageName(model.customImageName);
            this.setBlueprintId(model.blueprintId);
            this.setBundleId(model.bundleId);
            this.setUserData(model.userData);
            this.setKeyPairName(model.keyPairName);
        }

        public final Collection<String> getInstanceNames() {
            return this.instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCustomImageName() {
            return this.customImageName;
        }

        @Override
        public final Builder customImageName(String customImageName) {
            this.customImageName = customImageName;
            return this;
        }

        public final void setCustomImageName(String customImageName) {
            this.customImageName = customImageName;
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        public CreateInstancesRequest build() {
            return new CreateInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInstancesRequest> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);

        public Builder availabilityZone(String var1);

        public Builder customImageName(String var1);

        public Builder blueprintId(String var1);

        public Builder bundleId(String var1);

        public Builder userData(String var1);

        public Builder keyPairName(String var1);
    }
}

