/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CloseInstancePublicPortsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CloseInstancePublicPortsRequest.Builder, CloseInstancePublicPortsRequest> {
    private final PortInfo portInfo;

    private final String instanceName;

    private CloseInstancePublicPortsRequest(BuilderImpl builder) {
        this.portInfo = builder.portInfo;
        this.instanceName = builder.instanceName;
    }

    /**
     * <p>
     * Information about the public port you are trying to close.
     * </p>
     * 
     * @return Information about the public port you are trying to close.
     */
    public PortInfo portInfo() {
        return portInfo;
    }

    /**
     * <p>
     * The name of the instance on which you're attempting to close the public ports.
     * </p>
     * 
     * @return The name of the instance on which you're attempting to close the public ports.
     */
    public String instanceName() {
        return instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((portInfo() == null) ? 0 : portInfo().hashCode());
        hashCode = 31 * hashCode + ((instanceName() == null) ? 0 : instanceName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloseInstancePublicPortsRequest)) {
            return false;
        }
        CloseInstancePublicPortsRequest other = (CloseInstancePublicPortsRequest) obj;
        if (other.portInfo() == null ^ this.portInfo() == null) {
            return false;
        }
        if (other.portInfo() != null && !other.portInfo().equals(this.portInfo())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (portInfo() != null) {
            sb.append("PortInfo: ").append(portInfo()).append(",");
        }
        if (instanceName() != null) {
            sb.append("InstanceName: ").append(instanceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portInfo":
            return Optional.of(clazz.cast(portInfo()));
        case "instanceName":
            return Optional.of(clazz.cast(instanceName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CloseInstancePublicPortsRequest> {
        /**
         * <p>
         * Information about the public port you are trying to close.
         * </p>
         * 
         * @param portInfo
         *        Information about the public port you are trying to close.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portInfo(PortInfo portInfo);

        /**
         * <p>
         * The name of the instance on which you're attempting to close the public ports.
         * </p>
         * 
         * @param instanceName
         *        The name of the instance on which you're attempting to close the public ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);
    }

    static final class BuilderImpl implements Builder {
        private PortInfo portInfo;

        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloseInstancePublicPortsRequest model) {
            portInfo(model.portInfo);
            instanceName(model.instanceName);
        }

        public final PortInfo.Builder getPortInfo() {
            return portInfo != null ? portInfo.toBuilder() : null;
        }

        @Override
        public final Builder portInfo(PortInfo portInfo) {
            this.portInfo = portInfo;
            return this;
        }

        public final void setPortInfo(PortInfo.BuilderImpl portInfo) {
            this.portInfo = portInfo != null ? portInfo.build() : null;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public CloseInstancePublicPortsRequest build() {
            return new CloseInstancePublicPortsRequest(this);
        }
    }
}
