/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.DiskMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the hard disk (an SSD).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Disk implements StructuredPojo, ToCopyableBuilder<Disk.Builder, Disk> {
    private final String name;

    private final String arn;

    private final String supportCode;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final Integer sizeInGb;

    private final Integer gbInUse;

    private final Boolean isSystemDisk;

    private final Integer iops;

    private final String path;

    private final String attachedTo;

    private final Boolean isAttached;

    private final String attachmentState;

    private Disk(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.sizeInGb = builder.sizeInGb;
        this.gbInUse = builder.gbInUse;
        this.isSystemDisk = builder.isSystemDisk;
        this.iops = builder.iops;
        this.path = builder.path;
        this.attachedTo = builder.attachedTo;
        this.isAttached = builder.isAttached;
        this.attachmentState = builder.attachmentState;
    }

    /**
     * <p>
     * The name of the disk.
     * </p>
     * 
     * @return The name of the disk.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the disk.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the disk.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about an instance or another
     * resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about an instance or
     *         another resource in Lightsail. This code enables our support team to look up your Lightsail information
     *         more easily.
     */
    public String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The date when the disk was created.
     * </p>
     * 
     * @return The date when the disk was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The region and Availability Zone where the disk is located.
     * </p>
     * 
     * @return The region and Availability Zone where the disk is located.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The resource type of the disk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The resource type of the disk.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type of the disk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The resource type of the disk.
     * @see ResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The size of the disk in GB.
     * </p>
     * 
     * @return The size of the disk in GB.
     */
    public Integer sizeInGb() {
        return sizeInGb;
    }

    /**
     * <p>
     * The number of GB in use by the disk.
     * </p>
     * 
     * @return The number of GB in use by the disk.
     */
    public Integer gbInUse() {
        return gbInUse;
    }

    /**
     * <p>
     * A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
     * </p>
     * 
     * @return A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
     */
    public Boolean isSystemDisk() {
        return isSystemDisk;
    }

    /**
     * <p>
     * The input/output operations per second (IOPS) of the disk.
     * </p>
     * 
     * @return The input/output operations per second (IOPS) of the disk.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The disk path.
     * </p>
     * 
     * @return The disk path.
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * The resources to which the disk is attached.
     * </p>
     * 
     * @return The resources to which the disk is attached.
     */
    public String attachedTo() {
        return attachedTo;
    }

    /**
     * <p>
     * A Boolean value indicating whether the disk is attached.
     * </p>
     * 
     * @return A Boolean value indicating whether the disk is attached.
     */
    public Boolean isAttached() {
        return isAttached;
    }

    /**
     * <p>
     * The attachment state of the disk.
     * </p>
     * 
     * @return The attachment state of the disk.
     */
    public String attachmentState() {
        return attachmentState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((supportCode() == null) ? 0 : supportCode().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((resourceTypeString() == null) ? 0 : resourceTypeString().hashCode());
        hashCode = 31 * hashCode + ((sizeInGb() == null) ? 0 : sizeInGb().hashCode());
        hashCode = 31 * hashCode + ((gbInUse() == null) ? 0 : gbInUse().hashCode());
        hashCode = 31 * hashCode + ((isSystemDisk() == null) ? 0 : isSystemDisk().hashCode());
        hashCode = 31 * hashCode + ((iops() == null) ? 0 : iops().hashCode());
        hashCode = 31 * hashCode + ((path() == null) ? 0 : path().hashCode());
        hashCode = 31 * hashCode + ((attachedTo() == null) ? 0 : attachedTo().hashCode());
        hashCode = 31 * hashCode + ((isAttached() == null) ? 0 : isAttached().hashCode());
        hashCode = 31 * hashCode + ((attachmentState() == null) ? 0 : attachmentState().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Disk)) {
            return false;
        }
        Disk other = (Disk) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.supportCode() == null ^ this.supportCode() == null) {
            return false;
        }
        if (other.supportCode() != null && !other.supportCode().equals(this.supportCode())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.resourceTypeString() == null ^ this.resourceTypeString() == null) {
            return false;
        }
        if (other.resourceTypeString() != null && !other.resourceTypeString().equals(this.resourceTypeString())) {
            return false;
        }
        if (other.sizeInGb() == null ^ this.sizeInGb() == null) {
            return false;
        }
        if (other.sizeInGb() != null && !other.sizeInGb().equals(this.sizeInGb())) {
            return false;
        }
        if (other.gbInUse() == null ^ this.gbInUse() == null) {
            return false;
        }
        if (other.gbInUse() != null && !other.gbInUse().equals(this.gbInUse())) {
            return false;
        }
        if (other.isSystemDisk() == null ^ this.isSystemDisk() == null) {
            return false;
        }
        if (other.isSystemDisk() != null && !other.isSystemDisk().equals(this.isSystemDisk())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.attachedTo() == null ^ this.attachedTo() == null) {
            return false;
        }
        if (other.attachedTo() != null && !other.attachedTo().equals(this.attachedTo())) {
            return false;
        }
        if (other.isAttached() == null ^ this.isAttached() == null) {
            return false;
        }
        if (other.isAttached() != null && !other.isAttached().equals(this.isAttached())) {
            return false;
        }
        if (other.attachmentState() == null ^ this.attachmentState() == null) {
            return false;
        }
        if (other.attachmentState() != null && !other.attachmentState().equals(this.attachmentState())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (supportCode() != null) {
            sb.append("SupportCode: ").append(supportCode()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (sizeInGb() != null) {
            sb.append("SizeInGb: ").append(sizeInGb()).append(",");
        }
        if (gbInUse() != null) {
            sb.append("GbInUse: ").append(gbInUse()).append(",");
        }
        if (isSystemDisk() != null) {
            sb.append("IsSystemDisk: ").append(isSystemDisk()).append(",");
        }
        if (iops() != null) {
            sb.append("Iops: ").append(iops()).append(",");
        }
        if (path() != null) {
            sb.append("Path: ").append(path()).append(",");
        }
        if (attachedTo() != null) {
            sb.append("AttachedTo: ").append(attachedTo()).append(",");
        }
        if (isAttached() != null) {
            sb.append("IsAttached: ").append(isAttached()).append(",");
        }
        if (attachmentState() != null) {
            sb.append("AttachmentState: ").append(attachmentState()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "supportCode":
            return Optional.of(clazz.cast(supportCode()));
        case "createdAt":
            return Optional.of(clazz.cast(createdAt()));
        case "location":
            return Optional.of(clazz.cast(location()));
        case "resourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "sizeInGb":
            return Optional.of(clazz.cast(sizeInGb()));
        case "gbInUse":
            return Optional.of(clazz.cast(gbInUse()));
        case "isSystemDisk":
            return Optional.of(clazz.cast(isSystemDisk()));
        case "iops":
            return Optional.of(clazz.cast(iops()));
        case "path":
            return Optional.of(clazz.cast(path()));
        case "attachedTo":
            return Optional.of(clazz.cast(attachedTo()));
        case "isAttached":
            return Optional.of(clazz.cast(isAttached()));
        case "attachmentState":
            return Optional.of(clazz.cast(attachmentState()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Disk> {
        /**
         * <p>
         * The name of the disk.
         * </p>
         * 
         * @param name
         *        The name of the disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the disk.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about an instance or
         * another resource in Lightsail. This code enables our support team to look up your Lightsail information more
         * easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about an instance
         *        or another resource in Lightsail. This code enables our support team to look up your Lightsail
         *        information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The date when the disk was created.
         * </p>
         * 
         * @param createdAt
         *        The date when the disk was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The region and Availability Zone where the disk is located.
         * </p>
         * 
         * @param location
         *        The region and Availability Zone where the disk is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The resource type of the disk.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the disk.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type of the disk.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the disk.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The size of the disk in GB.
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);

        /**
         * <p>
         * The number of GB in use by the disk.
         * </p>
         * 
         * @param gbInUse
         *        The number of GB in use by the disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gbInUse(Integer gbInUse);

        /**
         * <p>
         * A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
         * </p>
         * 
         * @param isSystemDisk
         *        A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSystemDisk(Boolean isSystemDisk);

        /**
         * <p>
         * The input/output operations per second (IOPS) of the disk.
         * </p>
         * 
         * @param iops
         *        The input/output operations per second (IOPS) of the disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The disk path.
         * </p>
         * 
         * @param path
         *        The disk path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The resources to which the disk is attached.
         * </p>
         * 
         * @param attachedTo
         *        The resources to which the disk is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedTo(String attachedTo);

        /**
         * <p>
         * A Boolean value indicating whether the disk is attached.
         * </p>
         * 
         * @param isAttached
         *        A Boolean value indicating whether the disk is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAttached(Boolean isAttached);

        /**
         * <p>
         * The attachment state of the disk.
         * </p>
         * 
         * @param attachmentState
         *        The attachment state of the disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentState(String attachmentState);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private Integer sizeInGb;

        private Integer gbInUse;

        private Boolean isSystemDisk;

        private Integer iops;

        private String path;

        private String attachedTo;

        private Boolean isAttached;

        private String attachmentState;

        private BuilderImpl() {
        }

        private BuilderImpl(Disk model) {
            name(model.name);
            arn(model.arn);
            supportCode(model.supportCode);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            sizeInGb(model.sizeInGb);
            gbInUse(model.gbInUse);
            isSystemDisk(model.isSystemDisk);
            iops(model.iops);
            path(model.path);
            attachedTo(model.attachedTo);
            isAttached(model.isAttached);
            attachmentState(model.attachmentState);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final Integer getGbInUse() {
            return gbInUse;
        }

        @Override
        public final Builder gbInUse(Integer gbInUse) {
            this.gbInUse = gbInUse;
            return this;
        }

        public final void setGbInUse(Integer gbInUse) {
            this.gbInUse = gbInUse;
        }

        public final Boolean getIsSystemDisk() {
            return isSystemDisk;
        }

        @Override
        public final Builder isSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
            return this;
        }

        public final void setIsSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getAttachedTo() {
            return attachedTo;
        }

        @Override
        public final Builder attachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final void setAttachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
        }

        public final Boolean getIsAttached() {
            return isAttached;
        }

        @Override
        public final Builder isAttached(Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        public final void setIsAttached(Boolean isAttached) {
            this.isAttached = isAttached;
        }

        public final String getAttachmentState() {
            return attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        @Override
        public Disk build() {
            return new Disk(this);
        }
    }
}
