/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBundlesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBundlesResponse.Builder, GetBundlesResponse> {
    private final List<Bundle> bundles;

    private final String nextPageToken;

    private GetBundlesResponse(BuilderImpl builder) {
        this.bundles = builder.bundles;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs that contains information about the available bundles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs that contains information about the available bundles.
     */
    public List<Bundle> bundles() {
        return bundles;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get active names request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get active names request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bundles() == null) ? 0 : bundles().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBundlesResponse)) {
            return false;
        }
        GetBundlesResponse other = (GetBundlesResponse) obj;
        if (other.bundles() == null ^ this.bundles() == null) {
            return false;
        }
        if (other.bundles() != null && !other.bundles().equals(this.bundles())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bundles() != null) {
            sb.append("Bundles: ").append(bundles()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bundles":
            return Optional.of(clazz.cast(bundles()));
        case "nextPageToken":
            return Optional.of(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetBundlesResponse> {
        /**
         * <p>
         * An array of key-value pairs that contains information about the available bundles.
         * </p>
         * 
         * @param bundles
         *        An array of key-value pairs that contains information about the available bundles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundles(Collection<Bundle> bundles);

        /**
         * <p>
         * An array of key-value pairs that contains information about the available bundles.
         * </p>
         * 
         * @param bundles
         *        An array of key-value pairs that contains information about the available bundles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundles(Bundle... bundles);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get active names request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get active names request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Bundle> bundles;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBundlesResponse model) {
            bundles(model.bundles);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Bundle.Builder> getBundles() {
            return bundles != null ? bundles.stream().map(Bundle::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bundles(Collection<Bundle> bundles) {
            this.bundles = BundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Bundle... bundles) {
            bundles(Arrays.asList(bundles));
            return this;
        }

        public final void setBundles(Collection<Bundle.BuilderImpl> bundles) {
            this.bundles = BundleListCopier.copyFromBuilder(bundles);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetBundlesResponse build() {
            return new GetBundlesResponse(this);
        }
    }
}
