/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInstanceResponse.Builder, GetInstanceResponse> {
    private final Instance instance;

    private GetInstanceResponse(BuilderImpl builder) {
        this.instance = builder.instance;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the specified instance.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the specified instance.
     */
    public Instance instance() {
        return instance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instance() == null) ? 0 : instance().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceResponse)) {
            return false;
        }
        GetInstanceResponse other = (GetInstanceResponse) obj;
        if (other.instance() == null ^ this.instance() == null) {
            return false;
        }
        if (other.instance() != null && !other.instance().equals(this.instance())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instance() != null) {
            sb.append("Instance: ").append(instance()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instance":
            return Optional.of(clazz.cast(instance()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstanceResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the specified instance.
         * </p>
         * 
         * @param instance
         *        An array of key-value pairs containing information about the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(Instance instance);
    }

    static final class BuilderImpl implements Builder {
        private Instance instance;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceResponse model) {
            instance(model.instance);
        }

        public final Instance.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        @Override
        public final Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        public final void setInstance(Instance.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        public GetInstanceResponse build() {
            return new GetInstanceResponse(this);
        }
    }
}
