/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOperationsForResourceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetOperationsForResourceResponse.Builder, GetOperationsForResourceResponse> {
    private final List<Operation> operations;

    private final String nextPageCount;

    private final String nextPageToken;

    private GetOperationsForResourceResponse(BuilderImpl builder) {
        this.operations = builder.operations;
        this.nextPageCount = builder.nextPageCount;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get operations for resource request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get operations for resource
     *         request.
     */
    public List<Operation> operations() {
        return operations;
    }

    /**
     * <p>
     * (Deprecated) Returns the number of pages of results that remain.
     * </p>
     * <note>
     * <p>
     * In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now deprecated,
     * and the API returns the <code>nextPageToken</code> parameter instead.
     * </p>
     * </note>
     * 
     * @return (Deprecated) Returns the number of pages of results that remain.</p> <note>
     *         <p>
     *         In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now
     *         deprecated, and the API returns the <code>nextPageToken</code> parameter instead.
     *         </p>
     */
    public String nextPageCount() {
        return nextPageCount;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operations() == null) ? 0 : operations().hashCode());
        hashCode = 31 * hashCode + ((nextPageCount() == null) ? 0 : nextPageCount().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsForResourceResponse)) {
            return false;
        }
        GetOperationsForResourceResponse other = (GetOperationsForResourceResponse) obj;
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        if (other.operations() != null && !other.operations().equals(this.operations())) {
            return false;
        }
        if (other.nextPageCount() == null ^ this.nextPageCount() == null) {
            return false;
        }
        if (other.nextPageCount() != null && !other.nextPageCount().equals(this.nextPageCount())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (operations() != null) {
            sb.append("Operations: ").append(operations()).append(",");
        }
        if (nextPageCount() != null) {
            sb.append("NextPageCount: ").append(nextPageCount()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operations":
            return Optional.of(clazz.cast(operations()));
        case "nextPageCount":
            return Optional.of(clazz.cast(nextPageCount()));
        case "nextPageToken":
            return Optional.of(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetOperationsForResourceResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get operations for resource
         * request.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your get operations for
         *        resource request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get operations for resource
         * request.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your get operations for
         *        resource request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);

        /**
         * <p>
         * (Deprecated) Returns the number of pages of results that remain.
         * </p>
         * <note>
         * <p>
         * In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now
         * deprecated, and the API returns the <code>nextPageToken</code> parameter instead.
         * </p>
         * </note>
         * 
         * @param nextPageCount
         *        (Deprecated) Returns the number of pages of results that remain.</p> <note>
         *        <p>
         *        In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now
         *        deprecated, and the API returns the <code>nextPageToken</code> parameter instead.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageCount(String nextPageCount);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextPageToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Operation> operations;

        private String nextPageCount;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsForResourceResponse model) {
            operations(model.operations);
            nextPageCount(model.nextPageCount);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Operation.Builder> getOperations() {
            return operations != null ? operations.stream().map(Operation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        public final String getNextPageCount() {
            return nextPageCount;
        }

        @Override
        public final Builder nextPageCount(String nextPageCount) {
            this.nextPageCount = nextPageCount;
            return this;
        }

        public final void setNextPageCount(String nextPageCount) {
            this.nextPageCount = nextPageCount;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetOperationsForResourceResponse build() {
            return new GetOperationsForResourceResponse(this);
        }
    }
}
