/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetStaticIpsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetStaticIpsResponse.Builder, GetStaticIpsResponse> {
    private final List<StaticIp> staticIps;

    private final String nextPageToken;

    private GetStaticIpsResponse(BuilderImpl builder) {
        this.staticIps = builder.staticIps;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about your get static IPs request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about your get static IPs request.
     */
    public List<StaticIp> staticIps() {
        return staticIps;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get static IPs request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get static IPs request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((staticIps() == null) ? 0 : staticIps().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStaticIpsResponse)) {
            return false;
        }
        GetStaticIpsResponse other = (GetStaticIpsResponse) obj;
        if (other.staticIps() == null ^ this.staticIps() == null) {
            return false;
        }
        if (other.staticIps() != null && !other.staticIps().equals(this.staticIps())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (staticIps() != null) {
            sb.append("StaticIps: ").append(staticIps()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "staticIps":
            return Optional.of(clazz.cast(staticIps()));
        case "nextPageToken":
            return Optional.of(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetStaticIpsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about your get static IPs request.
         * </p>
         * 
         * @param staticIps
         *        An array of key-value pairs containing information about your get static IPs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIps(Collection<StaticIp> staticIps);

        /**
         * <p>
         * An array of key-value pairs containing information about your get static IPs request.
         * </p>
         * 
         * @param staticIps
         *        An array of key-value pairs containing information about your get static IPs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIps(StaticIp... staticIps);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get static IPs request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get static IPs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl implements Builder {
        private List<StaticIp> staticIps;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStaticIpsResponse model) {
            staticIps(model.staticIps);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<StaticIp.Builder> getStaticIps() {
            return staticIps != null ? staticIps.stream().map(StaticIp::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staticIps(Collection<StaticIp> staticIps) {
            this.staticIps = StaticIpListCopier.copy(staticIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticIps(StaticIp... staticIps) {
            staticIps(Arrays.asList(staticIps));
            return this;
        }

        public final void setStaticIps(Collection<StaticIp.BuilderImpl> staticIps) {
            this.staticIps = StaticIpListCopier.copyFromBuilder(staticIps);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetStaticIpsResponse build() {
            return new GetStaticIpsResponse(this);
        }
    }
}
