/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportKeyPairRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ImportKeyPairRequest.Builder, ImportKeyPairRequest> {
    private final String keyPairName;

    private final String publicKeyBase64;

    private ImportKeyPairRequest(BuilderImpl builder) {
        this.keyPairName = builder.keyPairName;
        this.publicKeyBase64 = builder.publicKeyBase64;
    }

    /**
     * <p>
     * The name of the key pair for which you want to import the public key.
     * </p>
     * 
     * @return The name of the key pair for which you want to import the public key.
     */
    public String keyPairName() {
        return keyPairName;
    }

    /**
     * <p>
     * A base64-encoded public key of the <code>ssh-rsa</code> type.
     * </p>
     * 
     * @return A base64-encoded public key of the <code>ssh-rsa</code> type.
     */
    public String publicKeyBase64() {
        return publicKeyBase64;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyPairName() == null) ? 0 : keyPairName().hashCode());
        hashCode = 31 * hashCode + ((publicKeyBase64() == null) ? 0 : publicKeyBase64().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest) obj;
        if (other.keyPairName() == null ^ this.keyPairName() == null) {
            return false;
        }
        if (other.keyPairName() != null && !other.keyPairName().equals(this.keyPairName())) {
            return false;
        }
        if (other.publicKeyBase64() == null ^ this.publicKeyBase64() == null) {
            return false;
        }
        if (other.publicKeyBase64() != null && !other.publicKeyBase64().equals(this.publicKeyBase64())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (keyPairName() != null) {
            sb.append("KeyPairName: ").append(keyPairName()).append(",");
        }
        if (publicKeyBase64() != null) {
            sb.append("PublicKeyBase64: ").append(publicKeyBase64()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyPairName":
            return Optional.of(clazz.cast(keyPairName()));
        case "publicKeyBase64":
            return Optional.of(clazz.cast(publicKeyBase64()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ImportKeyPairRequest> {
        /**
         * <p>
         * The name of the key pair for which you want to import the public key.
         * </p>
         * 
         * @param keyPairName
         *        The name of the key pair for which you want to import the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairName(String keyPairName);

        /**
         * <p>
         * A base64-encoded public key of the <code>ssh-rsa</code> type.
         * </p>
         * 
         * @param publicKeyBase64
         *        A base64-encoded public key of the <code>ssh-rsa</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyBase64(String publicKeyBase64);
    }

    static final class BuilderImpl implements Builder {
        private String keyPairName;

        private String publicKeyBase64;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairRequest model) {
            keyPairName(model.keyPairName);
            publicKeyBase64(model.publicKeyBase64);
        }

        public final String getKeyPairName() {
            return keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        public final String getPublicKeyBase64() {
            return publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        @Override
        public ImportKeyPairRequest build() {
            return new ImportKeyPairRequest(this);
        }
    }
}
