/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.InstanceAccessDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for gaining temporary access to one of your Amazon Lightsail instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceAccessDetails implements StructuredPojo,
        ToCopyableBuilder<InstanceAccessDetails.Builder, InstanceAccessDetails> {
    private final String certKey;

    private final Instant expiresAt;

    private final String ipAddress;

    private final String password;

    private final String privateKey;

    private final String protocol;

    private final String instanceName;

    private final String username;

    private InstanceAccessDetails(BuilderImpl builder) {
        this.certKey = builder.certKey;
        this.expiresAt = builder.expiresAt;
        this.ipAddress = builder.ipAddress;
        this.password = builder.password;
        this.privateKey = builder.privateKey;
        this.protocol = builder.protocol;
        this.instanceName = builder.instanceName;
        this.username = builder.username;
    }

    /**
     * <p>
     * For SSH access, the public key to use when accessing your instance For OpenSSH clients (e.g., command line SSH),
     * you should save this value to <code>tempkey-cert.pub</code>.
     * </p>
     * 
     * @return For SSH access, the public key to use when accessing your instance For OpenSSH clients (e.g., command
     *         line SSH), you should save this value to <code>tempkey-cert.pub</code>.
     */
    public String certKey() {
        return certKey;
    }

    /**
     * <p>
     * For SSH access, the date on which the temporary keys expire.
     * </p>
     * 
     * @return For SSH access, the date on which the temporary keys expire.
     */
    public Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * The public IP address of the Amazon Lightsail instance.
     * </p>
     * 
     * @return The public IP address of the Amazon Lightsail instance.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * For RDP access, the temporary password of the Amazon EC2 instance.
     * </p>
     * 
     * @return For RDP access, the temporary password of the Amazon EC2 instance.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * For SSH access, the temporary private key. For OpenSSH clients (e.g., command line SSH), you should save this
     * value to <code>tempkey</code>).
     * </p>
     * 
     * @return For SSH access, the temporary private key. For OpenSSH clients (e.g., command line SSH), you should save
     *         this value to <code>tempkey</code>).
     */
    public String privateKey() {
        return privateKey;
    }

    /**
     * <p>
     * The protocol for these Amazon Lightsail instance access details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link InstanceAccessProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolString}.
     * </p>
     * 
     * @return The protocol for these Amazon Lightsail instance access details.
     * @see InstanceAccessProtocol
     */
    public InstanceAccessProtocol protocol() {
        return InstanceAccessProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol for these Amazon Lightsail instance access details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link InstanceAccessProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolString}.
     * </p>
     * 
     * @return The protocol for these Amazon Lightsail instance access details.
     * @see InstanceAccessProtocol
     */
    public String protocolString() {
        return protocol;
    }

    /**
     * <p>
     * The name of this Amazon Lightsail instance.
     * </p>
     * 
     * @return The name of this Amazon Lightsail instance.
     */
    public String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The user name to use when logging in to the Amazon Lightsail instance.
     * </p>
     * 
     * @return The user name to use when logging in to the Amazon Lightsail instance.
     */
    public String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certKey() == null) ? 0 : certKey().hashCode());
        hashCode = 31 * hashCode + ((expiresAt() == null) ? 0 : expiresAt().hashCode());
        hashCode = 31 * hashCode + ((ipAddress() == null) ? 0 : ipAddress().hashCode());
        hashCode = 31 * hashCode + ((password() == null) ? 0 : password().hashCode());
        hashCode = 31 * hashCode + ((privateKey() == null) ? 0 : privateKey().hashCode());
        hashCode = 31 * hashCode + ((protocolString() == null) ? 0 : protocolString().hashCode());
        hashCode = 31 * hashCode + ((instanceName() == null) ? 0 : instanceName().hashCode());
        hashCode = 31 * hashCode + ((username() == null) ? 0 : username().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAccessDetails)) {
            return false;
        }
        InstanceAccessDetails other = (InstanceAccessDetails) obj;
        if (other.certKey() == null ^ this.certKey() == null) {
            return false;
        }
        if (other.certKey() != null && !other.certKey().equals(this.certKey())) {
            return false;
        }
        if (other.expiresAt() == null ^ this.expiresAt() == null) {
            return false;
        }
        if (other.expiresAt() != null && !other.expiresAt().equals(this.expiresAt())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.password() == null ^ this.password() == null) {
            return false;
        }
        if (other.password() != null && !other.password().equals(this.password())) {
            return false;
        }
        if (other.privateKey() == null ^ this.privateKey() == null) {
            return false;
        }
        if (other.privateKey() != null && !other.privateKey().equals(this.privateKey())) {
            return false;
        }
        if (other.protocolString() == null ^ this.protocolString() == null) {
            return false;
        }
        if (other.protocolString() != null && !other.protocolString().equals(this.protocolString())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (certKey() != null) {
            sb.append("CertKey: ").append(certKey()).append(",");
        }
        if (expiresAt() != null) {
            sb.append("ExpiresAt: ").append(expiresAt()).append(",");
        }
        if (ipAddress() != null) {
            sb.append("IpAddress: ").append(ipAddress()).append(",");
        }
        if (password() != null) {
            sb.append("Password: ").append(password()).append(",");
        }
        if (privateKey() != null) {
            sb.append("PrivateKey: ").append(privateKey()).append(",");
        }
        if (protocolString() != null) {
            sb.append("Protocol: ").append(protocolString()).append(",");
        }
        if (instanceName() != null) {
            sb.append("InstanceName: ").append(instanceName()).append(",");
        }
        if (username() != null) {
            sb.append("Username: ").append(username()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certKey":
            return Optional.of(clazz.cast(certKey()));
        case "expiresAt":
            return Optional.of(clazz.cast(expiresAt()));
        case "ipAddress":
            return Optional.of(clazz.cast(ipAddress()));
        case "password":
            return Optional.of(clazz.cast(password()));
        case "privateKey":
            return Optional.of(clazz.cast(privateKey()));
        case "protocol":
            return Optional.of(clazz.cast(protocolString()));
        case "instanceName":
            return Optional.of(clazz.cast(instanceName()));
        case "username":
            return Optional.of(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAccessDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceAccessDetails> {
        /**
         * <p>
         * For SSH access, the public key to use when accessing your instance For OpenSSH clients (e.g., command line
         * SSH), you should save this value to <code>tempkey-cert.pub</code>.
         * </p>
         * 
         * @param certKey
         *        For SSH access, the public key to use when accessing your instance For OpenSSH clients (e.g., command
         *        line SSH), you should save this value to <code>tempkey-cert.pub</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certKey(String certKey);

        /**
         * <p>
         * For SSH access, the date on which the temporary keys expire.
         * </p>
         * 
         * @param expiresAt
         *        For SSH access, the date on which the temporary keys expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * The public IP address of the Amazon Lightsail instance.
         * </p>
         * 
         * @param ipAddress
         *        The public IP address of the Amazon Lightsail instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * For RDP access, the temporary password of the Amazon EC2 instance.
         * </p>
         * 
         * @param password
         *        For RDP access, the temporary password of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * For SSH access, the temporary private key. For OpenSSH clients (e.g., command line SSH), you should save this
         * value to <code>tempkey</code>).
         * </p>
         * 
         * @param privateKey
         *        For SSH access, the temporary private key. For OpenSSH clients (e.g., command line SSH), you should
         *        save this value to <code>tempkey</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);

        /**
         * <p>
         * The protocol for these Amazon Lightsail instance access details.
         * </p>
         * 
         * @param protocol
         *        The protocol for these Amazon Lightsail instance access details.
         * @see InstanceAccessProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAccessProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol for these Amazon Lightsail instance access details.
         * </p>
         * 
         * @param protocol
         *        The protocol for these Amazon Lightsail instance access details.
         * @see InstanceAccessProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAccessProtocol
         */
        Builder protocol(InstanceAccessProtocol protocol);

        /**
         * <p>
         * The name of this Amazon Lightsail instance.
         * </p>
         * 
         * @param instanceName
         *        The name of this Amazon Lightsail instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The user name to use when logging in to the Amazon Lightsail instance.
         * </p>
         * 
         * @param username
         *        The user name to use when logging in to the Amazon Lightsail instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private String certKey;

        private Instant expiresAt;

        private String ipAddress;

        private String password;

        private String privateKey;

        private String protocol;

        private String instanceName;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAccessDetails model) {
            certKey(model.certKey);
            expiresAt(model.expiresAt);
            ipAddress(model.ipAddress);
            password(model.password);
            privateKey(model.privateKey);
            protocol(model.protocol);
            instanceName(model.instanceName);
            username(model.username);
        }

        public final String getCertKey() {
            return certKey;
        }

        @Override
        public final Builder certKey(String certKey) {
            this.certKey = certKey;
            return this;
        }

        public final void setCertKey(String certKey) {
            this.certKey = certKey;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(InstanceAccessProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public InstanceAccessDetails build() {
            return new InstanceAccessDetails(this);
        }
    }
}
