/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.InstancePortStateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the port state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstancePortState implements StructuredPojo, ToCopyableBuilder<InstancePortState.Builder, InstancePortState> {
    private final Integer fromPort;

    private final Integer toPort;

    private final String protocol;

    private final String state;

    private InstancePortState(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
        this.state = builder.state;
    }

    /**
     * <p>
     * The first port in the range.
     * </p>
     * 
     * @return The first port in the range.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The last port in the range.
     * </p>
     * 
     * @return The last port in the range.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * The protocol being used. Can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of
     * streamed data between applications running on hosts communicating by an IP network. If you have an application
     * that doesn't require reliable data stream service, use UDP instead.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>all</code> - All transport layer protocol types. For more general information, see <a
     * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to
     * other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission
     * channels or data paths. Applications that don't require reliable data stream service can use UDP, which provides
     * a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable
     * data stream service, use TCP instead.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link NetworkProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolString}.
     * </p>
     * 
     * @return The protocol being used. Can be one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
     *         delivery of streamed data between applications running on hosts communicating by an IP network. If you
     *         have an application that doesn't require reliable data stream service, use UDP instead.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>all</code> - All transport layer protocol types. For more general information, see <a
     *         href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
     *         datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to
     *         set up transmission channels or data paths. Applications that don't require reliable data stream service
     *         can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over
     *         reliability. If you do require reliable data stream service, use TCP instead.
     *         </p>
     *         </li>
     * @see NetworkProtocol
     */
    public NetworkProtocol protocol() {
        return NetworkProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol being used. Can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of
     * streamed data between applications running on hosts communicating by an IP network. If you have an application
     * that doesn't require reliable data stream service, use UDP instead.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>all</code> - All transport layer protocol types. For more general information, see <a
     * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to
     * other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission
     * channels or data paths. Applications that don't require reliable data stream service can use UDP, which provides
     * a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable
     * data stream service, use TCP instead.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link NetworkProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolString}.
     * </p>
     * 
     * @return The protocol being used. Can be one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
     *         delivery of streamed data between applications running on hosts communicating by an IP network. If you
     *         have an application that doesn't require reliable data stream service, use UDP instead.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>all</code> - All transport layer protocol types. For more general information, see <a
     *         href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
     *         datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to
     *         set up transmission channels or data paths. Applications that don't require reliable data stream service
     *         can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over
     *         reliability. If you do require reliable data stream service, use TCP instead.
     *         </p>
     *         </li>
     * @see NetworkProtocol
     */
    public String protocolString() {
        return protocol;
    }

    /**
     * <p>
     * Specifies whether the instance port is <code>open</code> or <code>closed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PortState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return Specifies whether the instance port is <code>open</code> or <code>closed</code>.
     * @see PortState
     */
    public PortState state() {
        return PortState.fromValue(state);
    }

    /**
     * <p>
     * Specifies whether the instance port is <code>open</code> or <code>closed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PortState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return Specifies whether the instance port is <code>open</code> or <code>closed</code>.
     * @see PortState
     */
    public String stateString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fromPort() == null) ? 0 : fromPort().hashCode());
        hashCode = 31 * hashCode + ((toPort() == null) ? 0 : toPort().hashCode());
        hashCode = 31 * hashCode + ((protocolString() == null) ? 0 : protocolString().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePortState)) {
            return false;
        }
        InstancePortState other = (InstancePortState) obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.protocolString() == null ^ this.protocolString() == null) {
            return false;
        }
        if (other.protocolString() != null && !other.protocolString().equals(this.protocolString())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fromPort() != null) {
            sb.append("FromPort: ").append(fromPort()).append(",");
        }
        if (toPort() != null) {
            sb.append("ToPort: ").append(toPort()).append(",");
        }
        if (protocolString() != null) {
            sb.append("Protocol: ").append(protocolString()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fromPort":
            return Optional.of(clazz.cast(fromPort()));
        case "toPort":
            return Optional.of(clazz.cast(toPort()));
        case "protocol":
            return Optional.of(clazz.cast(protocolString()));
        case "state":
            return Optional.of(clazz.cast(stateString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePortStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstancePortState> {
        /**
         * <p>
         * The first port in the range.
         * </p>
         * 
         * @param fromPort
         *        The first port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The last port in the range.
         * </p>
         * 
         * @param toPort
         *        The last port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The protocol being used. Can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery
         * of streamed data between applications running on hosts communicating by an IP network. If you have an
         * application that doesn't require reliable data stream service, use UDP instead.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>all</code> - All transport layer protocol types. For more general information, see <a
         * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams)
         * to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up
         * transmission channels or data paths. Applications that don't require reliable data stream service can use
         * UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If
         * you do require reliable data stream service, use TCP instead.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocol being used. Can be one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
         *        delivery of streamed data between applications running on hosts communicating by an IP network. If you
         *        have an application that doesn't require reliable data stream service, use UDP instead.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>all</code> - All transport layer protocol types. For more general information, see <a
         *        href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
         *        datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required
         *        to set up transmission channels or data paths. Applications that don't require reliable data stream
         *        service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency
         *        over reliability. If you do require reliable data stream service, use TCP instead.
         *        </p>
         *        </li>
         * @see NetworkProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol being used. Can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery
         * of streamed data between applications running on hosts communicating by an IP network. If you have an
         * application that doesn't require reliable data stream service, use UDP instead.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>all</code> - All transport layer protocol types. For more general information, see <a
         * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams)
         * to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up
         * transmission channels or data paths. Applications that don't require reliable data stream service can use
         * UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If
         * you do require reliable data stream service, use TCP instead.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocol being used. Can be one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
         *        delivery of streamed data between applications running on hosts communicating by an IP network. If you
         *        have an application that doesn't require reliable data stream service, use UDP instead.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>all</code> - All transport layer protocol types. For more general information, see <a
         *        href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
         *        datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required
         *        to set up transmission channels or data paths. Applications that don't require reliable data stream
         *        service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency
         *        over reliability. If you do require reliable data stream service, use TCP instead.
         *        </p>
         *        </li>
         * @see NetworkProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(NetworkProtocol protocol);

        /**
         * <p>
         * Specifies whether the instance port is <code>open</code> or <code>closed</code>.
         * </p>
         * 
         * @param state
         *        Specifies whether the instance port is <code>open</code> or <code>closed</code>.
         * @see PortState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortState
         */
        Builder state(String state);

        /**
         * <p>
         * Specifies whether the instance port is <code>open</code> or <code>closed</code>.
         * </p>
         * 
         * @param state
         *        Specifies whether the instance port is <code>open</code> or <code>closed</code>.
         * @see PortState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortState
         */
        Builder state(PortState state);
    }

    static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private Integer toPort;

        private String protocol;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePortState model) {
            fromPort(model.fromPort);
            toPort(model.toPort);
            protocol(model.protocol);
            state(model.state);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PortState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public InstancePortState build() {
            return new InstancePortState(this);
        }
    }
}
