/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.InstanceSnapshotMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the snapshot of the virtual private server, or <i>instance</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceSnapshot implements StructuredPojo, ToCopyableBuilder<InstanceSnapshot.Builder, InstanceSnapshot> {
    private final String name;

    private final String arn;

    private final String supportCode;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final String state;

    private final String progress;

    private final String fromInstanceName;

    private final String fromInstanceArn;

    private final String fromBlueprintId;

    private final String fromBundleId;

    private final Integer sizeInGb;

    private InstanceSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.state = builder.state;
        this.progress = builder.progress;
        this.fromInstanceName = builder.fromInstanceName;
        this.fromInstanceArn = builder.fromInstanceArn;
        this.fromBlueprintId = builder.fromBlueprintId;
        this.fromBundleId = builder.fromBundleId;
        this.sizeInGb = builder.sizeInGb;
    }

    /**
     * <p>
     * The name of the snapshot.
     * </p>
     * 
     * @return The name of the snapshot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot (e.g.,
     * <code>arn:aws:lightsail:us-east-1:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE</code>).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot (e.g.,
     *         <code>arn:aws:lightsail:us-east-1:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE</code>
     *         ).
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about an instance or another
     * resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about an instance or
     *         another resource in Lightsail. This code enables our support team to look up your Lightsail information
     *         more easily.
     */
    public String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The timestamp when the snapshot was created (e.g., <code>1479907467.024</code>).
     * </p>
     * 
     * @return The timestamp when the snapshot was created (e.g., <code>1479907467.024</code>).
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The region name and availability zone where you created the snapshot.
     * </p>
     * 
     * @return The region name and availability zone where you created the snapshot.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The type of resource (usually <code>InstanceSnapshot</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource (usually <code>InstanceSnapshot</code>).
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource (usually <code>InstanceSnapshot</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource (usually <code>InstanceSnapshot</code>).
     * @see ResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The state the snapshot is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceSnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state the snapshot is in.
     * @see InstanceSnapshotState
     */
    public InstanceSnapshotState state() {
        return InstanceSnapshotState.fromValue(state);
    }

    /**
     * <p>
     * The state the snapshot is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceSnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state the snapshot is in.
     * @see InstanceSnapshotState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The progress of the snapshot.
     * </p>
     * 
     * @return The progress of the snapshot.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * The instance from which the snapshot was created.
     * </p>
     * 
     * @return The instance from which the snapshot was created.
     */
    public String fromInstanceName() {
        return fromInstanceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g.,
     * <code>arn:aws:lightsail:us-east-1:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE</code>).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g.,
     *         <code>arn:aws:lightsail:us-east-1:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE</code>).
     */
    public String fromInstanceArn() {
        return fromInstanceArn;
    }

    /**
     * <p>
     * The blueprint ID from which you created the snapshot (e.g., <code>os_debian_8_3</code>). A blueprint is a virtual
     * private server (or <i>instance</i>) image used to create instances quickly.
     * </p>
     * 
     * @return The blueprint ID from which you created the snapshot (e.g., <code>os_debian_8_3</code>). A blueprint is a
     *         virtual private server (or <i>instance</i>) image used to create instances quickly.
     */
    public String fromBlueprintId() {
        return fromBlueprintId;
    }

    /**
     * <p>
     * The bundle ID from which you created the snapshot (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle ID from which you created the snapshot (e.g., <code>micro_1_0</code>).
     */
    public String fromBundleId() {
        return fromBundleId;
    }

    /**
     * <p>
     * The size in GB of the SSD.
     * </p>
     * 
     * @return The size in GB of the SSD.
     */
    public Integer sizeInGb() {
        return sizeInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((supportCode() == null) ? 0 : supportCode().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((resourceTypeString() == null) ? 0 : resourceTypeString().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        hashCode = 31 * hashCode + ((progress() == null) ? 0 : progress().hashCode());
        hashCode = 31 * hashCode + ((fromInstanceName() == null) ? 0 : fromInstanceName().hashCode());
        hashCode = 31 * hashCode + ((fromInstanceArn() == null) ? 0 : fromInstanceArn().hashCode());
        hashCode = 31 * hashCode + ((fromBlueprintId() == null) ? 0 : fromBlueprintId().hashCode());
        hashCode = 31 * hashCode + ((fromBundleId() == null) ? 0 : fromBundleId().hashCode());
        hashCode = 31 * hashCode + ((sizeInGb() == null) ? 0 : sizeInGb().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSnapshot)) {
            return false;
        }
        InstanceSnapshot other = (InstanceSnapshot) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.supportCode() == null ^ this.supportCode() == null) {
            return false;
        }
        if (other.supportCode() != null && !other.supportCode().equals(this.supportCode())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.resourceTypeString() == null ^ this.resourceTypeString() == null) {
            return false;
        }
        if (other.resourceTypeString() != null && !other.resourceTypeString().equals(this.resourceTypeString())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.fromInstanceName() == null ^ this.fromInstanceName() == null) {
            return false;
        }
        if (other.fromInstanceName() != null && !other.fromInstanceName().equals(this.fromInstanceName())) {
            return false;
        }
        if (other.fromInstanceArn() == null ^ this.fromInstanceArn() == null) {
            return false;
        }
        if (other.fromInstanceArn() != null && !other.fromInstanceArn().equals(this.fromInstanceArn())) {
            return false;
        }
        if (other.fromBlueprintId() == null ^ this.fromBlueprintId() == null) {
            return false;
        }
        if (other.fromBlueprintId() != null && !other.fromBlueprintId().equals(this.fromBlueprintId())) {
            return false;
        }
        if (other.fromBundleId() == null ^ this.fromBundleId() == null) {
            return false;
        }
        if (other.fromBundleId() != null && !other.fromBundleId().equals(this.fromBundleId())) {
            return false;
        }
        if (other.sizeInGb() == null ^ this.sizeInGb() == null) {
            return false;
        }
        if (other.sizeInGb() != null && !other.sizeInGb().equals(this.sizeInGb())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (supportCode() != null) {
            sb.append("SupportCode: ").append(supportCode()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (progress() != null) {
            sb.append("Progress: ").append(progress()).append(",");
        }
        if (fromInstanceName() != null) {
            sb.append("FromInstanceName: ").append(fromInstanceName()).append(",");
        }
        if (fromInstanceArn() != null) {
            sb.append("FromInstanceArn: ").append(fromInstanceArn()).append(",");
        }
        if (fromBlueprintId() != null) {
            sb.append("FromBlueprintId: ").append(fromBlueprintId()).append(",");
        }
        if (fromBundleId() != null) {
            sb.append("FromBundleId: ").append(fromBundleId()).append(",");
        }
        if (sizeInGb() != null) {
            sb.append("SizeInGb: ").append(sizeInGb()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "supportCode":
            return Optional.of(clazz.cast(supportCode()));
        case "createdAt":
            return Optional.of(clazz.cast(createdAt()));
        case "location":
            return Optional.of(clazz.cast(location()));
        case "resourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "state":
            return Optional.of(clazz.cast(stateString()));
        case "progress":
            return Optional.of(clazz.cast(progress()));
        case "fromInstanceName":
            return Optional.of(clazz.cast(fromInstanceName()));
        case "fromInstanceArn":
            return Optional.of(clazz.cast(fromInstanceArn()));
        case "fromBlueprintId":
            return Optional.of(clazz.cast(fromBlueprintId()));
        case "fromBundleId":
            return Optional.of(clazz.cast(fromBundleId()));
        case "sizeInGb":
            return Optional.of(clazz.cast(sizeInGb()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceSnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceSnapshot> {
        /**
         * <p>
         * The name of the snapshot.
         * </p>
         * 
         * @param name
         *        The name of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot (e.g.,
         * <code>arn:aws:lightsail:us-east-1:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE</code>).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the snapshot (e.g.,
         *        <code>arn:aws:lightsail:us-east-1:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about an instance or
         * another resource in Lightsail. This code enables our support team to look up your Lightsail information more
         * easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about an instance
         *        or another resource in Lightsail. This code enables our support team to look up your Lightsail
         *        information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The timestamp when the snapshot was created (e.g., <code>1479907467.024</code>).
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the snapshot was created (e.g., <code>1479907467.024</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The region name and availability zone where you created the snapshot.
         * </p>
         * 
         * @param location
         *        The region name and availability zone where you created the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The type of resource (usually <code>InstanceSnapshot</code>).
         * </p>
         * 
         * @param resourceType
         *        The type of resource (usually <code>InstanceSnapshot</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource (usually <code>InstanceSnapshot</code>).
         * </p>
         * 
         * @param resourceType
         *        The type of resource (usually <code>InstanceSnapshot</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The state the snapshot is in.
         * </p>
         * 
         * @param state
         *        The state the snapshot is in.
         * @see InstanceSnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceSnapshotState
         */
        Builder state(String state);

        /**
         * <p>
         * The state the snapshot is in.
         * </p>
         * 
         * @param state
         *        The state the snapshot is in.
         * @see InstanceSnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceSnapshotState
         */
        Builder state(InstanceSnapshotState state);

        /**
         * <p>
         * The progress of the snapshot.
         * </p>
         * 
         * @param progress
         *        The progress of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The instance from which the snapshot was created.
         * </p>
         * 
         * @param fromInstanceName
         *        The instance from which the snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromInstanceName(String fromInstanceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g.,
         * <code>arn:aws:lightsail:us-east-1:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE</code>).
         * </p>
         * 
         * @param fromInstanceArn
         *        The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g.,
         *        <code>arn:aws:lightsail:us-east-1:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromInstanceArn(String fromInstanceArn);

        /**
         * <p>
         * The blueprint ID from which you created the snapshot (e.g., <code>os_debian_8_3</code>). A blueprint is a
         * virtual private server (or <i>instance</i>) image used to create instances quickly.
         * </p>
         * 
         * @param fromBlueprintId
         *        The blueprint ID from which you created the snapshot (e.g., <code>os_debian_8_3</code>). A blueprint
         *        is a virtual private server (or <i>instance</i>) image used to create instances quickly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromBlueprintId(String fromBlueprintId);

        /**
         * <p>
         * The bundle ID from which you created the snapshot (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param fromBundleId
         *        The bundle ID from which you created the snapshot (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromBundleId(String fromBundleId);

        /**
         * <p>
         * The size in GB of the SSD.
         * </p>
         * 
         * @param sizeInGb
         *        The size in GB of the SSD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private String state;

        private String progress;

        private String fromInstanceName;

        private String fromInstanceArn;

        private String fromBlueprintId;

        private String fromBundleId;

        private Integer sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSnapshot model) {
            name(model.name);
            arn(model.arn);
            supportCode(model.supportCode);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            state(model.state);
            progress(model.progress);
            fromInstanceName(model.fromInstanceName);
            fromInstanceArn(model.fromInstanceArn);
            fromBlueprintId(model.fromBlueprintId);
            fromBundleId(model.fromBundleId);
            sizeInGb(model.sizeInGb);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceSnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getFromInstanceName() {
            return fromInstanceName;
        }

        @Override
        public final Builder fromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
            return this;
        }

        public final void setFromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
        }

        public final String getFromInstanceArn() {
            return fromInstanceArn;
        }

        @Override
        public final Builder fromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
            return this;
        }

        public final void setFromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
        }

        public final String getFromBlueprintId() {
            return fromBlueprintId;
        }

        @Override
        public final Builder fromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
            return this;
        }

        public final void setFromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
        }

        public final String getFromBundleId() {
            return fromBundleId;
        }

        @Override
        public final Builder fromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
            return this;
        }

        public final void setFromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        public InstanceSnapshot build() {
            return new InstanceSnapshot(this);
        }
    }
}
