/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.MonthlyTransferMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the monthly data transfer in and out of your virtual private server (or <i>instance</i>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MonthlyTransfer implements StructuredPojo, ToCopyableBuilder<MonthlyTransfer.Builder, MonthlyTransfer> {
    private final Integer gbPerMonthAllocated;

    private MonthlyTransfer(BuilderImpl builder) {
        this.gbPerMonthAllocated = builder.gbPerMonthAllocated;
    }

    /**
     * <p>
     * The amount allocated per month (in GB).
     * </p>
     * 
     * @return The amount allocated per month (in GB).
     */
    public Integer gbPerMonthAllocated() {
        return gbPerMonthAllocated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((gbPerMonthAllocated() == null) ? 0 : gbPerMonthAllocated().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonthlyTransfer)) {
            return false;
        }
        MonthlyTransfer other = (MonthlyTransfer) obj;
        if (other.gbPerMonthAllocated() == null ^ this.gbPerMonthAllocated() == null) {
            return false;
        }
        if (other.gbPerMonthAllocated() != null && !other.gbPerMonthAllocated().equals(this.gbPerMonthAllocated())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (gbPerMonthAllocated() != null) {
            sb.append("GbPerMonthAllocated: ").append(gbPerMonthAllocated()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gbPerMonthAllocated":
            return Optional.of(clazz.cast(gbPerMonthAllocated()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MonthlyTransferMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MonthlyTransfer> {
        /**
         * <p>
         * The amount allocated per month (in GB).
         * </p>
         * 
         * @param gbPerMonthAllocated
         *        The amount allocated per month (in GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gbPerMonthAllocated(Integer gbPerMonthAllocated);
    }

    static final class BuilderImpl implements Builder {
        private Integer gbPerMonthAllocated;

        private BuilderImpl() {
        }

        private BuilderImpl(MonthlyTransfer model) {
            gbPerMonthAllocated(model.gbPerMonthAllocated);
        }

        public final Integer getGbPerMonthAllocated() {
            return gbPerMonthAllocated;
        }

        @Override
        public final Builder gbPerMonthAllocated(Integer gbPerMonthAllocated) {
            this.gbPerMonthAllocated = gbPerMonthAllocated;
            return this;
        }

        public final void setGbPerMonthAllocated(Integer gbPerMonthAllocated) {
            this.gbPerMonthAllocated = gbPerMonthAllocated;
        }

        @Override
        public MonthlyTransfer build() {
            return new MonthlyTransfer(this);
        }
    }
}
