/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutInstancePublicPortsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutInstancePublicPortsRequest.Builder, PutInstancePublicPortsRequest> {
    private final List<PortInfo> portInfos;

    private final String instanceName;

    private PutInstancePublicPortsRequest(BuilderImpl builder) {
        this.portInfos = builder.portInfos;
        this.instanceName = builder.instanceName;
    }

    /**
     * <p>
     * Specifies information about the public port(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies information about the public port(s).
     */
    public List<PortInfo> portInfos() {
        return portInfos;
    }

    /**
     * <p>
     * The Lightsail instance name of the public port(s) you are setting.
     * </p>
     * 
     * @return The Lightsail instance name of the public port(s) you are setting.
     */
    public String instanceName() {
        return instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((portInfos() == null) ? 0 : portInfos().hashCode());
        hashCode = 31 * hashCode + ((instanceName() == null) ? 0 : instanceName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInstancePublicPortsRequest)) {
            return false;
        }
        PutInstancePublicPortsRequest other = (PutInstancePublicPortsRequest) obj;
        if (other.portInfos() == null ^ this.portInfos() == null) {
            return false;
        }
        if (other.portInfos() != null && !other.portInfos().equals(this.portInfos())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (portInfos() != null) {
            sb.append("PortInfos: ").append(portInfos()).append(",");
        }
        if (instanceName() != null) {
            sb.append("InstanceName: ").append(instanceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portInfos":
            return Optional.of(clazz.cast(portInfos()));
        case "instanceName":
            return Optional.of(clazz.cast(instanceName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutInstancePublicPortsRequest> {
        /**
         * <p>
         * Specifies information about the public port(s).
         * </p>
         * 
         * @param portInfos
         *        Specifies information about the public port(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portInfos(Collection<PortInfo> portInfos);

        /**
         * <p>
         * Specifies information about the public port(s).
         * </p>
         * 
         * @param portInfos
         *        Specifies information about the public port(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portInfos(PortInfo... portInfos);

        /**
         * <p>
         * The Lightsail instance name of the public port(s) you are setting.
         * </p>
         * 
         * @param instanceName
         *        The Lightsail instance name of the public port(s) you are setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);
    }

    static final class BuilderImpl implements Builder {
        private List<PortInfo> portInfos;

        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInstancePublicPortsRequest model) {
            portInfos(model.portInfos);
            instanceName(model.instanceName);
        }

        public final Collection<PortInfo.Builder> getPortInfos() {
            return portInfos != null ? portInfos.stream().map(PortInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portInfos(Collection<PortInfo> portInfos) {
            this.portInfos = PortInfoListCopier.copy(portInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portInfos(PortInfo... portInfos) {
            portInfos(Arrays.asList(portInfos));
            return this;
        }

        public final void setPortInfos(Collection<PortInfo.BuilderImpl> portInfos) {
            this.portInfos = PortInfoListCopier.copyFromBuilder(portInfos);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public PutInstancePublicPortsRequest build() {
            return new PutInstancePublicPortsRequest(this);
        }
    }
}
