/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutInstancePublicPortsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutInstancePublicPortsResponse.Builder, PutInstancePublicPortsResponse> {
    private final Operation operation;

    private PutInstancePublicPortsResponse(BuilderImpl builder) {
        this.operation = builder.operation;
    }

    /**
     * <p>
     * Describes metadata about the operation you just executed.
     * </p>
     * 
     * @return Describes metadata about the operation you just executed.
     */
    public Operation operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operation() == null) ? 0 : operation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInstancePublicPortsResponse)) {
            return false;
        }
        PutInstancePublicPortsResponse other = (PutInstancePublicPortsResponse) obj;
        if (other.operation() == null ^ this.operation() == null) {
            return false;
        }
        if (other.operation() != null && !other.operation().equals(this.operation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (operation() != null) {
            sb.append("Operation: ").append(operation()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operation":
            return Optional.of(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutInstancePublicPortsResponse> {
        /**
         * <p>
         * Describes metadata about the operation you just executed.
         * </p>
         * 
         * @param operation
         *        Describes metadata about the operation you just executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(Operation operation);
    }

    static final class BuilderImpl implements Builder {
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInstancePublicPortsResponse model) {
            operation(model.operation);
        }

        public final Operation.Builder getOperation() {
            return operation != null ? operation.toBuilder() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public PutInstancePublicPortsResponse build() {
            return new PutInstancePublicPortsResponse(this);
        }
    }
}
