/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.RegionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the AWS Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Region implements StructuredPojo, ToCopyableBuilder<Region.Builder, Region> {
    private final String continentCode;

    private final String description;

    private final String displayName;

    private final String name;

    private final List<AvailabilityZone> availabilityZones;

    private Region(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.name = builder.name;
        this.availabilityZones = builder.availabilityZones;
    }

    /**
     * <p>
     * The continent code (e.g., <code>NA</code>, meaning North America).
     * </p>
     * 
     * @return The continent code (e.g., <code>NA</code>, meaning North America).
     */
    public String continentCode() {
        return continentCode;
    }

    /**
     * <p>
     * The description of the AWS Region (e.g.,
     * <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).
     * </p>
     * 
     * @return The description of the AWS Region (e.g.,
     *         <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The display name (e.g., <code>Virginia</code>).
     * </p>
     * 
     * @return The display name (e.g., <code>Virginia</code>).
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The region name (e.g., <code>us-east-1</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameString}.
     * </p>
     * 
     * @return The region name (e.g., <code>us-east-1</code>).
     * @see RegionName
     */
    public RegionName name() {
        return RegionName.fromValue(name);
    }

    /**
     * <p>
     * The region name (e.g., <code>us-east-1</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameString}.
     * </p>
     * 
     * @return The region name (e.g., <code>us-east-1</code>).
     * @see RegionName
     */
    public String nameString() {
        return name;
    }

    /**
     * <p>
     * The Availability Zones. Follows the format <code>us-east-1a</code> (case-sensitive).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Availability Zones. Follows the format <code>us-east-1a</code> (case-sensitive).
     */
    public List<AvailabilityZone> availabilityZones() {
        return availabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((continentCode() == null) ? 0 : continentCode().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((displayName() == null) ? 0 : displayName().hashCode());
        hashCode = 31 * hashCode + ((nameString() == null) ? 0 : nameString().hashCode());
        hashCode = 31 * hashCode + ((availabilityZones() == null) ? 0 : availabilityZones().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region) obj;
        if (other.continentCode() == null ^ this.continentCode() == null) {
            return false;
        }
        if (other.continentCode() != null && !other.continentCode().equals(this.continentCode())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.nameString() == null ^ this.nameString() == null) {
            return false;
        }
        if (other.nameString() != null && !other.nameString().equals(this.nameString())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (continentCode() != null) {
            sb.append("ContinentCode: ").append(continentCode()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (nameString() != null) {
            sb.append("Name: ").append(nameString()).append(",");
        }
        if (availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(availabilityZones()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "continentCode":
            return Optional.of(clazz.cast(continentCode()));
        case "description":
            return Optional.of(clazz.cast(description()));
        case "displayName":
            return Optional.of(clazz.cast(displayName()));
        case "name":
            return Optional.of(clazz.cast(nameString()));
        case "availabilityZones":
            return Optional.of(clazz.cast(availabilityZones()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Region> {
        /**
         * <p>
         * The continent code (e.g., <code>NA</code>, meaning North America).
         * </p>
         * 
         * @param continentCode
         *        The continent code (e.g., <code>NA</code>, meaning North America).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continentCode(String continentCode);

        /**
         * <p>
         * The description of the AWS Region (e.g.,
         * <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>).
         * </p>
         * 
         * @param description
         *        The description of the AWS Region (e.g.,
         *        <code>This region is recommended to serve users in the eastern United States and eastern Canada</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name (e.g., <code>Virginia</code>).
         * </p>
         * 
         * @param displayName
         *        The display name (e.g., <code>Virginia</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The region name (e.g., <code>us-east-1</code>).
         * </p>
         * 
         * @param name
         *        The region name (e.g., <code>us-east-1</code>).
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder name(String name);

        /**
         * <p>
         * The region name (e.g., <code>us-east-1</code>).
         * </p>
         * 
         * @param name
         *        The region name (e.g., <code>us-east-1</code>).
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder name(RegionName name);

        /**
         * <p>
         * The Availability Zones. Follows the format <code>us-east-1a</code> (case-sensitive).
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones. Follows the format <code>us-east-1a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AvailabilityZone> availabilityZones);

        /**
         * <p>
         * The Availability Zones. Follows the format <code>us-east-1a</code> (case-sensitive).
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones. Follows the format <code>us-east-1a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AvailabilityZone... availabilityZones);
    }

    static final class BuilderImpl implements Builder {
        private String continentCode;

        private String description;

        private String displayName;

        private String name;

        private List<AvailabilityZone> availabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            continentCode(model.continentCode);
            description(model.description);
            displayName(model.displayName);
            name(model.name);
            availabilityZones(model.availabilityZones);
        }

        public final String getContinentCode() {
            return continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RegionName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<AvailabilityZone.Builder> getAvailabilityZones() {
            return availabilityZones != null ? availabilityZones.stream().map(AvailabilityZone::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public Region build() {
            return new Region(this);
        }
    }
}
