/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ReleaseStaticIpRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ReleaseStaticIpRequest.Builder, ReleaseStaticIpRequest> {
    private final String staticIpName;

    private ReleaseStaticIpRequest(BuilderImpl builder) {
        this.staticIpName = builder.staticIpName;
    }

    /**
     * <p>
     * The name of the static IP to delete.
     * </p>
     * 
     * @return The name of the static IP to delete.
     */
    public String staticIpName() {
        return staticIpName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((staticIpName() == null) ? 0 : staticIpName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseStaticIpRequest)) {
            return false;
        }
        ReleaseStaticIpRequest other = (ReleaseStaticIpRequest) obj;
        if (other.staticIpName() == null ^ this.staticIpName() == null) {
            return false;
        }
        if (other.staticIpName() != null && !other.staticIpName().equals(this.staticIpName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (staticIpName() != null) {
            sb.append("StaticIpName: ").append(staticIpName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "staticIpName":
            return Optional.of(clazz.cast(staticIpName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReleaseStaticIpRequest> {
        /**
         * <p>
         * The name of the static IP to delete.
         * </p>
         * 
         * @param staticIpName
         *        The name of the static IP to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIpName(String staticIpName);
    }

    static final class BuilderImpl implements Builder {
        private String staticIpName;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseStaticIpRequest model) {
            staticIpName(model.staticIpName);
        }

        public final String getStaticIpName() {
            return staticIpName;
        }

        @Override
        public final Builder staticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
            return this;
        }

        public final void setStaticIpName(String staticIpName) {
            this.staticIpName = staticIpName;
        }

        @Override
        public ReleaseStaticIpRequest build() {
            return new ReleaseStaticIpRequest(this);
        }
    }
}
