/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lightsail.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * InstanceAccessDetails JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceAccessDetailsUnmarshaller implements Unmarshaller<InstanceAccessDetails, JsonUnmarshallerContext> {

    public InstanceAccessDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceAccessDetails.Builder instanceAccessDetailsBuilder = InstanceAccessDetails.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("certKey", targetDepth)) {
                    context.nextToken();
                    instanceAccessDetailsBuilder.certKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("expiresAt", targetDepth)) {
                    context.nextToken();
                    instanceAccessDetailsBuilder.expiresAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("ipAddress", targetDepth)) {
                    context.nextToken();
                    instanceAccessDetailsBuilder.ipAddress(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("password", targetDepth)) {
                    context.nextToken();
                    instanceAccessDetailsBuilder.password(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("privateKey", targetDepth)) {
                    context.nextToken();
                    instanceAccessDetailsBuilder.privateKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("protocol", targetDepth)) {
                    context.nextToken();
                    instanceAccessDetailsBuilder.protocol(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("instanceName", targetDepth)) {
                    context.nextToken();
                    instanceAccessDetailsBuilder.instanceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("username", targetDepth)) {
                    context.nextToken();
                    instanceAccessDetailsBuilder.username(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return instanceAccessDetailsBuilder.build();
    }

    private static final InstanceAccessDetailsUnmarshaller INSTANCE = new InstanceAccessDetailsUnmarshaller();

    public static InstanceAccessDetailsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
