/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.services.lightsail.model.OperationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteInstanceResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DeleteInstanceResponse> {
    private final List<Operation> operations;

    private DeleteInstanceResponse(BuilderImpl builder) {
        this.operations = builder.operations;
    }

    public List<Operation> operations() {
        return this.operations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.operations() == null ? 0 : this.operations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceResponse)) {
            return false;
        }
        DeleteInstanceResponse other = (DeleteInstanceResponse)((Object)obj);
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        return other.operations() == null || other.operations().equals(this.operations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.operations() != null) {
            sb.append("Operations: ").append(this.operations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operations": {
                return Optional.of(clazz.cast(this.operations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Operation> operations;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceResponse model) {
            this.operations(model.operations);
        }

        public final Collection<Operation.Builder> getOperations() {
            return this.operations != null ? (Collection)this.operations.stream().map(Operation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        public DeleteInstanceResponse build() {
            return new DeleteInstanceResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteInstanceResponse> {
        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);
    }
}

