/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceAccessDetailsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetInstanceAccessDetailsRequest> {
    private final String instanceName;
    private final String protocol;

    private GetInstanceAccessDetailsRequest(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.protocol = builder.protocol;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public InstanceAccessProtocol protocol() {
        return InstanceAccessProtocol.fromValue(this.protocol);
    }

    public String protocolString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        hashCode = 31 * hashCode + (this.protocolString() == null ? 0 : this.protocolString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceAccessDetailsRequest)) {
            return false;
        }
        GetInstanceAccessDetailsRequest other = (GetInstanceAccessDetailsRequest)((Object)obj);
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.protocolString() == null ^ this.protocolString() == null) {
            return false;
        }
        return other.protocolString() == null || other.protocolString().equals(this.protocolString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (this.protocolString() != null) {
            sb.append("Protocol: ").append(this.protocolString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "protocol": {
                return Optional.of(clazz.cast(this.protocolString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceAccessDetailsRequest model) {
            this.instanceName(model.instanceName);
            this.protocol(model.protocol);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(InstanceAccessProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public GetInstanceAccessDetailsRequest build() {
            return new GetInstanceAccessDetailsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInstanceAccessDetailsRequest> {
        public Builder instanceName(String var1);

        public Builder protocol(String var1);

        public Builder protocol(InstanceAccessProtocol var1);
    }
}

