/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.lightsail.model.InstanceMetricName;
import software.amazon.awssdk.services.lightsail.model.MetricStatistic;
import software.amazon.awssdk.services.lightsail.model.MetricStatisticListCopier;
import software.amazon.awssdk.services.lightsail.model.MetricUnit;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceMetricDataRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetInstanceMetricDataRequest> {
    private final String instanceName;
    private final String metricName;
    private final Integer period;
    private final Instant startTime;
    private final Instant endTime;
    private final String unit;
    private final List<String> statistics;

    private GetInstanceMetricDataRequest(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.metricName = builder.metricName;
        this.period = builder.period;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.unit = builder.unit;
        this.statistics = builder.statistics;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public InstanceMetricName metricName() {
        return InstanceMetricName.fromValue(this.metricName);
    }

    public String metricNameString() {
        return this.metricName;
    }

    public Integer period() {
        return this.period;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public MetricUnit unit() {
        return MetricUnit.fromValue(this.unit);
    }

    public String unitString() {
        return this.unit;
    }

    public List<MetricStatistic> statistics() {
        return TypeConverter.convert(this.statistics, MetricStatistic::fromValue);
    }

    public List<String> statisticsStrings() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        hashCode = 31 * hashCode + (this.metricNameString() == null ? 0 : this.metricNameString().hashCode());
        hashCode = 31 * hashCode + (this.period() == null ? 0 : this.period().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.unitString() == null ? 0 : this.unitString().hashCode());
        hashCode = 31 * hashCode + (this.statisticsStrings() == null ? 0 : this.statisticsStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetricDataRequest)) {
            return false;
        }
        GetInstanceMetricDataRequest other = (GetInstanceMetricDataRequest)((Object)obj);
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.metricNameString() == null ^ this.metricNameString() == null) {
            return false;
        }
        if (other.metricNameString() != null && !other.metricNameString().equals(this.metricNameString())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.unitString() == null ^ this.unitString() == null) {
            return false;
        }
        if (other.unitString() != null && !other.unitString().equals(this.unitString())) {
            return false;
        }
        if (other.statisticsStrings() == null ^ this.statisticsStrings() == null) {
            return false;
        }
        return other.statisticsStrings() == null || other.statisticsStrings().equals(this.statisticsStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (this.metricNameString() != null) {
            sb.append("MetricName: ").append(this.metricNameString()).append(",");
        }
        if (this.period() != null) {
            sb.append("Period: ").append(this.period()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.unitString() != null) {
            sb.append("Unit: ").append(this.unitString()).append(",");
        }
        if (this.statisticsStrings() != null) {
            sb.append("Statistics: ").append(this.statisticsStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "metricName": {
                return Optional.of(clazz.cast(this.metricNameString()));
            }
            case "period": {
                return Optional.of(clazz.cast(this.period()));
            }
            case "startTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "unit": {
                return Optional.of(clazz.cast(this.unitString()));
            }
            case "statistics": {
                return Optional.of(clazz.cast(this.statisticsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private String metricName;
        private Integer period;
        private Instant startTime;
        private Instant endTime;
        private String unit;
        private List<String> statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetricDataRequest model) {
            this.instanceName(model.instanceName);
            this.metricName(model.metricName);
            this.period(model.period);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.unit(model.unit);
            this.statistics(model.statistics);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Collection<String> getStatistics() {
            return this.statistics;
        }

        @Override
        public final Builder statistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(String ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
        }

        public GetInstanceMetricDataRequest build() {
            return new GetInstanceMetricDataRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInstanceMetricDataRequest> {
        public Builder instanceName(String var1);

        public Builder metricName(String var1);

        public Builder metricName(InstanceMetricName var1);

        public Builder period(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);

        public Builder statistics(Collection<String> var1);

        public Builder statistics(String ... var1);
    }
}

