/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.Blueprint;

public class BlueprintUnmarshaller
implements Unmarshaller<Blueprint, JsonUnmarshallerContext> {
    private static final BlueprintUnmarshaller INSTANCE = new BlueprintUnmarshaller();

    public Blueprint unmarshall(JsonUnmarshallerContext context) throws Exception {
        Blueprint.Builder blueprintBuilder = Blueprint.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("blueprintId", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.blueprintId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("group", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.group((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("isActive", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.isActive((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("minPower", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.minPower((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.version((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("versionCode", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.versionCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("productUrl", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.productUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("licenseUrl", targetDepth)) {
                    context.nextToken();
                    blueprintBuilder.licenseUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Blueprint)blueprintBuilder.build();
    }

    public static BlueprintUnmarshaller getInstance() {
        return INSTANCE;
    }
}

