/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInstancesFromSnapshotRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateInstancesFromSnapshotRequest.Builder, CreateInstancesFromSnapshotRequest> {
    private final List<String> instanceNames;

    private final Map<String, List<DiskMap>> attachedDiskMapping;

    private final String availabilityZone;

    private final String instanceSnapshotName;

    private final String bundleId;

    private final String userData;

    private final String keyPairName;

    private CreateInstancesFromSnapshotRequest(BuilderImpl builder) {
        this.instanceNames = builder.instanceNames;
        this.attachedDiskMapping = builder.attachedDiskMapping;
        this.availabilityZone = builder.availabilityZone;
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
    }

    /**
     * <p>
     * The names for your new instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names for your new instances.
     */
    public List<String> instanceNames() {
        return instanceNames;
    }

    /**
     * <p>
     * An object containing information about one or more disk mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object containing information about one or more disk mappings.
     */
    public Map<String, List<DiskMap>> attachedDiskMapping() {
        return attachedDiskMapping;
    }

    /**
     * <p>
     * The Availability Zone where you want to create your instances. Use the following formatting:
     * <code>us-east-2a</code> (case sensitive). You can get a list of availability zones by using the <a
     * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     * operation. Be sure to add the <code>include availability zones</code> parameter to your request.
     * </p>
     * 
     * @return The Availability Zone where you want to create your instances. Use the following formatting:
     *         <code>us-east-2a</code> (case sensitive). You can get a list of availability zones by using the <a
     *         href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     *         operation. Be sure to add the <code>include availability zones</code> parameter to your request.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots
     * operation to return information about your existing snapshots.
     * </p>
     * 
     * @return The name of the instance snapshot on which you are basing your new instances. Use the get instance
     *         snapshots operation to return information about your existing snapshots.
     */
    public String instanceSnapshotName() {
        return instanceSnapshotName;
    }

    /**
     * <p>
     * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
     * pricing plan (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle of specification information for your virtual private server (or <i>instance</i>), including
     *         the pricing plan (e.g., <code>micro_1_0</code>).
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * You can create a launch script that configures a server with additional user data. For example,
     * <code>apt-get –y update</code>.
     * </p>
     * <note>
     * <p>
     * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and
     * CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a
     * complete list, see the <a
     * href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev Guide</a>.
     * </p>
     * </note>
     * 
     * @return You can create a launch script that configures a server with additional user data. For example,
     *         <code>apt-get –y update</code>.</p> <note>
     *         <p>
     *         Depending on the machine image you choose, the command to get software on your instance varies. Amazon
     *         Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
     *         <code>pkg</code>. For a complete list, see the <a
     *         href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev Guide</a>.
     *         </p>
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * The name for your key pair.
     * </p>
     * 
     * @return The name for your key pair.
     */
    public String keyPairName() {
        return keyPairName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceNames());
        hashCode = 31 * hashCode + Objects.hashCode(attachedDiskMapping());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(instanceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesFromSnapshotRequest)) {
            return false;
        }
        CreateInstancesFromSnapshotRequest other = (CreateInstancesFromSnapshotRequest) obj;
        return Objects.equals(instanceNames(), other.instanceNames())
                && Objects.equals(attachedDiskMapping(), other.attachedDiskMapping())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(instanceSnapshotName(), other.instanceSnapshotName())
                && Objects.equals(bundleId(), other.bundleId()) && Objects.equals(userData(), other.userData())
                && Objects.equals(keyPairName(), other.keyPairName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceNames() != null) {
            sb.append("InstanceNames: ").append(instanceNames()).append(",");
        }
        if (attachedDiskMapping() != null) {
            sb.append("AttachedDiskMapping: ").append(attachedDiskMapping()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (instanceSnapshotName() != null) {
            sb.append("InstanceSnapshotName: ").append(instanceSnapshotName()).append(",");
        }
        if (bundleId() != null) {
            sb.append("BundleId: ").append(bundleId()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        if (keyPairName() != null) {
            sb.append("KeyPairName: ").append(keyPairName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceNames":
            return Optional.of(clazz.cast(instanceNames()));
        case "attachedDiskMapping":
            return Optional.of(clazz.cast(attachedDiskMapping()));
        case "availabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "instanceSnapshotName":
            return Optional.of(clazz.cast(instanceSnapshotName()));
        case "bundleId":
            return Optional.of(clazz.cast(bundleId()));
        case "userData":
            return Optional.of(clazz.cast(userData()));
        case "keyPairName":
            return Optional.of(clazz.cast(keyPairName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateInstancesFromSnapshotRequest> {
        /**
         * <p>
         * The names for your new instances.
         * </p>
         * 
         * @param instanceNames
         *        The names for your new instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(Collection<String> instanceNames);

        /**
         * <p>
         * The names for your new instances.
         * </p>
         * 
         * @param instanceNames
         *        The names for your new instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(String... instanceNames);

        /**
         * <p>
         * An object containing information about one or more disk mappings.
         * </p>
         * 
         * @param attachedDiskMapping
         *        An object containing information about one or more disk mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedDiskMapping(Map<String, ? extends Collection<DiskMap>> attachedDiskMapping);

        /**
         * <p>
         * The Availability Zone where you want to create your instances. Use the following formatting:
         * <code>us-east-2a</code> (case sensitive). You can get a list of availability zones by using the <a
         * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
         * operation. Be sure to add the <code>include availability zones</code> parameter to your request.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where you want to create your instances. Use the following formatting:
         *        <code>us-east-2a</code> (case sensitive). You can get a list of availability zones by using the <a
         *        href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get
         *        regions</a> operation. Be sure to add the <code>include availability zones</code> parameter to your
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots
         * operation to return information about your existing snapshots.
         * </p>
         * 
         * @param instanceSnapshotName
         *        The name of the instance snapshot on which you are basing your new instances. Use the get instance
         *        snapshots operation to return information about your existing snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshotName(String instanceSnapshotName);

        /**
         * <p>
         * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
         * pricing plan (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle of specification information for your virtual private server (or <i>instance</i>),
         *        including the pricing plan (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * You can create a launch script that configures a server with additional user data. For example,
         * <code>apt-get –y update</code>.
         * </p>
         * <note>
         * <p>
         * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux
         * and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         * <code>pkg</code>. For a complete list, see the <a
         * href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev Guide</a>.
         * </p>
         * </note>
         * 
         * @param userData
         *        You can create a launch script that configures a server with additional user data. For example,
         *        <code>apt-get –y update</code>.</p> <note>
         *        <p>
         *        Depending on the machine image you choose, the command to get software on your instance varies. Amazon
         *        Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         *        <code>pkg</code>. For a complete list, see the <a
         *        href="http://lightsail.aws.amazon.com/ls/docs/getting-started/articles/pre-installed-apps">Dev
         *        Guide</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The name for your key pair.
         * </p>
         * 
         * @param keyPairName
         *        The name for your key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairName(String keyPairName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> instanceNames;

        private Map<String, List<DiskMap>> attachedDiskMapping;

        private String availabilityZone;

        private String instanceSnapshotName;

        private String bundleId;

        private String userData;

        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesFromSnapshotRequest model) {
            instanceNames(model.instanceNames);
            attachedDiskMapping(model.attachedDiskMapping);
            availabilityZone(model.availabilityZone);
            instanceSnapshotName(model.instanceSnapshotName);
            bundleId(model.bundleId);
            userData(model.userData);
            keyPairName(model.keyPairName);
        }

        public final Collection<String> getInstanceNames() {
            return instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String... instanceNames) {
            instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        public final Map<String, ? extends Collection<DiskMap>> getAttachedDiskMapping() {
            return attachedDiskMapping;
        }

        @Override
        public final Builder attachedDiskMapping(Map<String, ? extends Collection<DiskMap>> attachedDiskMapping) {
            this.attachedDiskMapping = AttachedDiskMapCopier.copy(attachedDiskMapping);
            return this;
        }

        public final void setAttachedDiskMapping(Map<String, ? extends Collection<DiskMap>> attachedDiskMapping) {
            this.attachedDiskMapping = AttachedDiskMapCopier.copy(attachedDiskMapping);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getInstanceSnapshotName() {
            return instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getKeyPairName() {
            return keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public CreateInstancesFromSnapshotRequest build() {
            return new CreateInstancesFromSnapshotRequest(this);
        }
    }
}
