/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDisksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDisksResponse.Builder, GetDisksResponse> {
    private final List<Disk> disks;

    private final String nextPageToken;

    private GetDisksResponse(BuilderImpl builder) {
        this.disks = builder.disks;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of objects containing information about all block storage disks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects containing information about all block storage disks.
     */
    public List<Disk> disks() {
        return disks;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your GetDisks request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your GetDisks request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disks());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDisksResponse)) {
            return false;
        }
        GetDisksResponse other = (GetDisksResponse) obj;
        return Objects.equals(disks(), other.disks()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (disks() != null) {
            sb.append("Disks: ").append(disks()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "disks":
            return Optional.of(clazz.cast(disks()));
        case "nextPageToken":
            return Optional.of(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetDisksResponse> {
        /**
         * <p>
         * An array of objects containing information about all block storage disks.
         * </p>
         * 
         * @param disks
         *        An array of objects containing information about all block storage disks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(Collection<Disk> disks);

        /**
         * <p>
         * An array of objects containing information about all block storage disks.
         * </p>
         * 
         * @param disks
         *        An array of objects containing information about all block storage disks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(Disk... disks);

        /**
         * <p>
         * A token used for advancing to the next page of results from your GetDisks request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your GetDisks request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Disk> disks;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDisksResponse model) {
            disks(model.disks);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Disk.Builder> getDisks() {
            return disks != null ? disks.stream().map(Disk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder disks(Collection<Disk> disks) {
            this.disks = DiskListCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Disk... disks) {
            disks(Arrays.asList(disks));
            return this;
        }

        public final void setDisks(Collection<Disk.BuilderImpl> disks) {
            this.disks = DiskListCopier.copyFromBuilder(disks);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetDisksResponse build() {
            return new GetDisksResponse(this);
        }
    }
}
