/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDomainRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetDomainRequest.Builder, GetDomainRequest> {
    private final String domainName;

    private GetDomainRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
    }

    /**
     * <p>
     * The domain name for which your want to return information about.
     * </p>
     * 
     * @return The domain name for which your want to return information about.
     */
    public String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainRequest)) {
            return false;
        }
        GetDomainRequest other = (GetDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.of(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetDomainRequest> {
        /**
         * <p>
         * The domain name for which your want to return information about.
         * </p>
         * 
         * @param domainName
         *        The domain name for which your want to return information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainRequest model) {
            domainName(model.domainName);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public GetDomainRequest build() {
            return new GetDomainRequest(this);
        }
    }
}
