/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstancePortStatesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInstancePortStatesResponse.Builder, GetInstancePortStatesResponse> {
    private final List<InstancePortState> portStates;

    private GetInstancePortStatesResponse(BuilderImpl builder) {
        this.portStates = builder.portStates;
    }

    /**
     * <p>
     * Information about the port states resulting from your request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the port states resulting from your request.
     */
    public List<InstancePortState> portStates() {
        return portStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(portStates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancePortStatesResponse)) {
            return false;
        }
        GetInstancePortStatesResponse other = (GetInstancePortStatesResponse) obj;
        return Objects.equals(portStates(), other.portStates());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (portStates() != null) {
            sb.append("PortStates: ").append(portStates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portStates":
            return Optional.of(clazz.cast(portStates()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstancePortStatesResponse> {
        /**
         * <p>
         * Information about the port states resulting from your request.
         * </p>
         * 
         * @param portStates
         *        Information about the port states resulting from your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portStates(Collection<InstancePortState> portStates);

        /**
         * <p>
         * Information about the port states resulting from your request.
         * </p>
         * 
         * @param portStates
         *        Information about the port states resulting from your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portStates(InstancePortState... portStates);
    }

    static final class BuilderImpl implements Builder {
        private List<InstancePortState> portStates;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancePortStatesResponse model) {
            portStates(model.portStates);
        }

        public final Collection<InstancePortState.Builder> getPortStates() {
            return portStates != null ? portStates.stream().map(InstancePortState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portStates(Collection<InstancePortState> portStates) {
            this.portStates = InstancePortStateListCopier.copy(portStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(InstancePortState... portStates) {
            portStates(Arrays.asList(portStates));
            return this;
        }

        public final void setPortStates(Collection<InstancePortState.BuilderImpl> portStates) {
            this.portStates = InstancePortStateListCopier.copyFromBuilder(portStates);
        }

        @Override
        public GetInstancePortStatesResponse build() {
            return new GetInstancePortStatesResponse(this);
        }
    }
}
