/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceSnapshotResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInstanceSnapshotResponse.Builder, GetInstanceSnapshotResponse> {
    private final InstanceSnapshot instanceSnapshot;

    private GetInstanceSnapshotResponse(BuilderImpl builder) {
        this.instanceSnapshot = builder.instanceSnapshot;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get instance snapshot request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get instance snapshot
     *         request.
     */
    public InstanceSnapshot instanceSnapshot() {
        return instanceSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceSnapshot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceSnapshotResponse)) {
            return false;
        }
        GetInstanceSnapshotResponse other = (GetInstanceSnapshotResponse) obj;
        return Objects.equals(instanceSnapshot(), other.instanceSnapshot());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceSnapshot() != null) {
            sb.append("InstanceSnapshot: ").append(instanceSnapshot()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceSnapshot":
            return Optional.of(clazz.cast(instanceSnapshot()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstanceSnapshotResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshot request.
         * </p>
         * 
         * @param instanceSnapshot
         *        An array of key-value pairs containing information about the results of your get instance snapshot
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshot(InstanceSnapshot instanceSnapshot);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshot request.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceSnapshot.Builder} avoiding the need to
         * create one manually via {@link InstanceSnapshot#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceSnapshot.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceSnapshot(InstanceSnapshot)}.
         * 
         * @param instanceSnapshot
         *        a consumer that will call methods on {@link InstanceSnapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceSnapshot(InstanceSnapshot)
         */
        default Builder instanceSnapshot(Consumer<InstanceSnapshot.Builder> instanceSnapshot) {
            return instanceSnapshot(InstanceSnapshot.builder().apply(instanceSnapshot).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstanceSnapshot instanceSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceSnapshotResponse model) {
            instanceSnapshot(model.instanceSnapshot);
        }

        public final InstanceSnapshot.Builder getInstanceSnapshot() {
            return instanceSnapshot != null ? instanceSnapshot.toBuilder() : null;
        }

        @Override
        public final Builder instanceSnapshot(InstanceSnapshot instanceSnapshot) {
            this.instanceSnapshot = instanceSnapshot;
            return this;
        }

        public final void setInstanceSnapshot(InstanceSnapshot.BuilderImpl instanceSnapshot) {
            this.instanceSnapshot = instanceSnapshot != null ? instanceSnapshot.build() : null;
        }

        @Override
        public GetInstanceSnapshotResponse build() {
            return new GetInstanceSnapshotResponse(this);
        }
    }
}
