/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInstancesResponse.Builder, GetInstancesResponse> {
    private final List<Instance> instances;

    private final String nextPageToken;

    private GetInstancesResponse(BuilderImpl builder) {
        this.instances = builder.instances;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about your instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about your instances.
     */
    public List<Instance> instances() {
        return instances;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get instances request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get instances request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancesResponse)) {
            return false;
        }
        GetInstancesResponse other = (GetInstancesResponse) obj;
        return Objects.equals(instances(), other.instances()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instances() != null) {
            sb.append("Instances: ").append(instances()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instances":
            return Optional.of(clazz.cast(instances()));
        case "nextPageToken":
            return Optional.of(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetInstancesResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about your instances.
         * </p>
         * 
         * @param instances
         *        An array of key-value pairs containing information about your instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * An array of key-value pairs containing information about your instances.
         * </p>
         * 
         * @param instances
         *        An array of key-value pairs containing information about your instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get instances request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get instances request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Instance> instances;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancesResponse model) {
            instances(model.instances);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Instance.Builder> getInstances() {
            return instances != null ? instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetInstancesResponse build() {
            return new GetInstancesResponse(this);
        }
    }
}
