/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetKeyPairRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetKeyPairRequest.Builder, GetKeyPairRequest> {
    private final String keyPairName;

    private GetKeyPairRequest(BuilderImpl builder) {
        this.keyPairName = builder.keyPairName;
    }

    /**
     * <p>
     * The name of the key pair for which you are requesting information.
     * </p>
     * 
     * @return The name of the key pair for which you are requesting information.
     */
    public String keyPairName() {
        return keyPairName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyPairName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyPairRequest)) {
            return false;
        }
        GetKeyPairRequest other = (GetKeyPairRequest) obj;
        return Objects.equals(keyPairName(), other.keyPairName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (keyPairName() != null) {
            sb.append("KeyPairName: ").append(keyPairName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyPairName":
            return Optional.of(clazz.cast(keyPairName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetKeyPairRequest> {
        /**
         * <p>
         * The name of the key pair for which you are requesting information.
         * </p>
         * 
         * @param keyPairName
         *        The name of the key pair for which you are requesting information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairName(String keyPairName);
    }

    static final class BuilderImpl implements Builder {
        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyPairRequest model) {
            keyPairName(model.keyPairName);
        }

        public final String getKeyPairName() {
            return keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public GetKeyPairRequest build() {
            return new GetKeyPairRequest(this);
        }
    }
}
