/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOperationsForResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetOperationsForResourceRequest.Builder, GetOperationsForResourceRequest> {
    private final String resourceName;

    private final String pageToken;

    private GetOperationsForResourceRequest(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * The name of the resource for which you are requesting information.
     * </p>
     * 
     * @return The name of the resource for which you are requesting information.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get operations for resource request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get operations for resource request.
     */
    public String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsForResourceRequest)) {
            return false;
        }
        GetOperationsForResourceRequest other = (GetOperationsForResourceRequest) obj;
        return Objects.equals(resourceName(), other.resourceName()) && Objects.equals(pageToken(), other.pageToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceName() != null) {
            sb.append("ResourceName: ").append(resourceName()).append(",");
        }
        if (pageToken() != null) {
            sb.append("PageToken: ").append(pageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceName":
            return Optional.of(clazz.cast(resourceName()));
        case "pageToken":
            return Optional.of(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetOperationsForResourceRequest> {
        /**
         * <p>
         * The name of the resource for which you are requesting information.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource for which you are requesting information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get operations for resource request.
         * </p>
         * 
         * @param pageToken
         *        A token used for advancing to the next page of results from your get operations for resource request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);
    }

    static final class BuilderImpl implements Builder {
        private String resourceName;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsForResourceRequest model) {
            resourceName(model.resourceName);
            pageToken(model.pageToken);
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public GetOperationsForResourceRequest build() {
            return new GetOperationsForResourceRequest(this);
        }
    }
}
