/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOperationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetOperationsResponse.Builder, GetOperationsResponse> {
    private final List<Operation> operations;

    private final String nextPageToken;

    private GetOperationsResponse(BuilderImpl builder) {
        this.operations = builder.operations;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get operations request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get operations request.
     */
    public List<Operation> operations() {
        return operations;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get operations request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get operations request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operations());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsResponse)) {
            return false;
        }
        GetOperationsResponse other = (GetOperationsResponse) obj;
        return Objects.equals(operations(), other.operations()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (operations() != null) {
            sb.append("Operations: ").append(operations()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operations":
            return Optional.of(clazz.cast(operations()));
        case "nextPageToken":
            return Optional.of(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetOperationsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get operations request.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your get operations request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get operations request.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your get operations request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get operations request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get operations request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Operation> operations;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsResponse model) {
            operations(model.operations);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Operation.Builder> getOperations() {
            return operations != null ? operations.stream().map(Operation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetOperationsResponse build() {
            return new GetOperationsResponse(this);
        }
    }
}
