/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.PasswordDataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The password data for the Windows Server-based instance, including the ciphertext and the key pair name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PasswordData implements StructuredPojo, ToCopyableBuilder<PasswordData.Builder, PasswordData> {
    private final String ciphertext;

    private final String keyPairName;

    private PasswordData(BuilderImpl builder) {
        this.ciphertext = builder.ciphertext;
        this.keyPairName = builder.keyPairName;
    }

    /**
     * <p>
     * The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready yet. When
     * you create an instance, it can take up to 15 minutes for the instance to be ready.
     * </p>
     * <note>
     * <p>
     * If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted password will be available
     * in the password field.
     * </p>
     * <p>
     * If you are using a custom key pair, you need to use your own means of decryption.
     * </p>
     * <p>
     * If you change the Administrator password on the instance, Lightsail will continue to return the original
     * ciphertext value. When accessing the instance using RDP, you need to manually enter the Administrator password
     * after changing it from the default.
     * </p>
     * </note>
     * 
     * @return The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready
     *         yet. When you create an instance, it can take up to 15 minutes for the instance to be ready.</p> <note>
     *         <p>
     *         If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted password will be
     *         available in the password field.
     *         </p>
     *         <p>
     *         If you are using a custom key pair, you need to use your own means of decryption.
     *         </p>
     *         <p>
     *         If you change the Administrator password on the instance, Lightsail will continue to return the original
     *         ciphertext value. When accessing the instance using RDP, you need to manually enter the Administrator
     *         password after changing it from the default.
     *         </p>
     */
    public String ciphertext() {
        return ciphertext;
    }

    /**
     * <p>
     * The name of the key pair that you used when creating your instance. If no key pair name was specified when
     * creating the instance, Lightsail uses the default key pair (<code>LightsailDefaultKeyPair</code>).
     * </p>
     * <p>
     * If you are using a custom key pair, you need to use your own means of decrypting your password using the
     * <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting your password with the public key part of
     * this key pair.
     * </p>
     * 
     * @return The name of the key pair that you used when creating your instance. If no key pair name was specified
     *         when creating the instance, Lightsail uses the default key pair (<code>LightsailDefaultKeyPair</code>
     *         ).</p>
     *         <p>
     *         If you are using a custom key pair, you need to use your own means of decrypting your password using the
     *         <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting your password with the public key
     *         part of this key pair.
     */
    public String keyPairName() {
        return keyPairName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ciphertext());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordData)) {
            return false;
        }
        PasswordData other = (PasswordData) obj;
        return Objects.equals(ciphertext(), other.ciphertext()) && Objects.equals(keyPairName(), other.keyPairName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ciphertext() != null) {
            sb.append("Ciphertext: ").append(ciphertext()).append(",");
        }
        if (keyPairName() != null) {
            sb.append("KeyPairName: ").append(keyPairName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ciphertext":
            return Optional.of(clazz.cast(ciphertext()));
        case "keyPairName":
            return Optional.of(clazz.cast(keyPairName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PasswordDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PasswordData> {
        /**
         * <p>
         * The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready yet.
         * When you create an instance, it can take up to 15 minutes for the instance to be ready.
         * </p>
         * <note>
         * <p>
         * If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted password will be
         * available in the password field.
         * </p>
         * <p>
         * If you are using a custom key pair, you need to use your own means of decryption.
         * </p>
         * <p>
         * If you change the Administrator password on the instance, Lightsail will continue to return the original
         * ciphertext value. When accessing the instance using RDP, you need to manually enter the Administrator
         * password after changing it from the default.
         * </p>
         * </note>
         * 
         * @param ciphertext
         *        The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready
         *        yet. When you create an instance, it can take up to 15 minutes for the instance to be ready.</p>
         *        <note>
         *        <p>
         *        If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted password will be
         *        available in the password field.
         *        </p>
         *        <p>
         *        If you are using a custom key pair, you need to use your own means of decryption.
         *        </p>
         *        <p>
         *        If you change the Administrator password on the instance, Lightsail will continue to return the
         *        original ciphertext value. When accessing the instance using RDP, you need to manually enter the
         *        Administrator password after changing it from the default.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphertext(String ciphertext);

        /**
         * <p>
         * The name of the key pair that you used when creating your instance. If no key pair name was specified when
         * creating the instance, Lightsail uses the default key pair (<code>LightsailDefaultKeyPair</code>).
         * </p>
         * <p>
         * If you are using a custom key pair, you need to use your own means of decrypting your password using the
         * <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting your password with the public key
         * part of this key pair.
         * </p>
         * 
         * @param keyPairName
         *        The name of the key pair that you used when creating your instance. If no key pair name was specified
         *        when creating the instance, Lightsail uses the default key pair (<code>LightsailDefaultKeyPair</code>
         *        ).</p>
         *        <p>
         *        If you are using a custom key pair, you need to use your own means of decrypting your password using
         *        the <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting your password with the
         *        public key part of this key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairName(String keyPairName);
    }

    static final class BuilderImpl implements Builder {
        private String ciphertext;

        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordData model) {
            ciphertext(model.ciphertext);
            keyPairName(model.keyPairName);
        }

        public final String getCiphertext() {
            return ciphertext;
        }

        @Override
        public final Builder ciphertext(String ciphertext) {
            this.ciphertext = ciphertext;
            return this;
        }

        public final void setCiphertext(String ciphertext) {
            this.ciphertext = ciphertext;
        }

        public final String getKeyPairName() {
            return keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public PasswordData build() {
            return new PasswordData(this);
        }
    }
}
