/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDiskFromSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDiskFromSnapshotRequest> {
    private final String diskName;
    private final String diskSnapshotName;
    private final String availabilityZone;
    private final Integer sizeInGb;

    private CreateDiskFromSnapshotRequest(BuilderImpl builder) {
        this.diskName = builder.diskName;
        this.diskSnapshotName = builder.diskSnapshotName;
        this.availabilityZone = builder.availabilityZone;
        this.sizeInGb = builder.sizeInGb;
    }

    public String diskName() {
        return this.diskName;
    }

    public String diskSnapshotName() {
        return this.diskSnapshotName;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Integer sizeInGb() {
        return this.sizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.diskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskFromSnapshotRequest)) {
            return false;
        }
        CreateDiskFromSnapshotRequest other = (CreateDiskFromSnapshotRequest)((Object)obj);
        return Objects.equals(this.diskName(), other.diskName()) && Objects.equals(this.diskSnapshotName(), other.diskSnapshotName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.sizeInGb(), other.sizeInGb());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.diskName() != null) {
            sb.append("DiskName: ").append(this.diskName()).append(",");
        }
        if (this.diskSnapshotName() != null) {
            sb.append("DiskSnapshotName: ").append(this.diskSnapshotName()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.sizeInGb() != null) {
            sb.append("SizeInGb: ").append(this.sizeInGb()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskName": {
                return Optional.of(clazz.cast(this.diskName()));
            }
            case "diskSnapshotName": {
                return Optional.of(clazz.cast(this.diskSnapshotName()));
            }
            case "availabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "sizeInGb": {
                return Optional.of(clazz.cast(this.sizeInGb()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String diskName;
        private String diskSnapshotName;
        private String availabilityZone;
        private Integer sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskFromSnapshotRequest model) {
            this.diskName(model.diskName);
            this.diskSnapshotName(model.diskSnapshotName);
            this.availabilityZone(model.availabilityZone);
            this.sizeInGb(model.sizeInGb);
        }

        public final String getDiskName() {
            return this.diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getDiskSnapshotName() {
            return this.diskSnapshotName;
        }

        @Override
        public final Builder diskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        public final void setDiskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public CreateDiskFromSnapshotRequest build() {
            return new CreateDiskFromSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDiskFromSnapshotRequest> {
        public Builder diskName(String var1);

        public Builder diskSnapshotName(String var1);

        public Builder availabilityZone(String var1);

        public Builder sizeInGb(Integer var1);
    }
}

