/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lightsail.model.AttachedDiskMapCopier;
import software.amazon.awssdk.services.lightsail.model.DiskMap;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstancesFromSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateInstancesFromSnapshotRequest> {
    private final List<String> instanceNames;
    private final Map<String, List<DiskMap>> attachedDiskMapping;
    private final String availabilityZone;
    private final String instanceSnapshotName;
    private final String bundleId;
    private final String userData;
    private final String keyPairName;

    private CreateInstancesFromSnapshotRequest(BuilderImpl builder) {
        this.instanceNames = builder.instanceNames;
        this.attachedDiskMapping = builder.attachedDiskMapping;
        this.availabilityZone = builder.availabilityZone;
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    public Map<String, List<DiskMap>> attachedDiskMapping() {
        return this.attachedDiskMapping;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String instanceSnapshotName() {
        return this.instanceSnapshotName;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String userData() {
        return this.userData;
    }

    public String keyPairName() {
        return this.keyPairName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedDiskMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesFromSnapshotRequest)) {
            return false;
        }
        CreateInstancesFromSnapshotRequest other = (CreateInstancesFromSnapshotRequest)((Object)obj);
        return Objects.equals(this.instanceNames(), other.instanceNames()) && Objects.equals(this.attachedDiskMapping(), other.attachedDiskMapping()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceSnapshotName(), other.instanceSnapshotName()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.keyPairName(), other.keyPairName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceNames() != null) {
            sb.append("InstanceNames: ").append(this.instanceNames()).append(",");
        }
        if (this.attachedDiskMapping() != null) {
            sb.append("AttachedDiskMapping: ").append(this.attachedDiskMapping()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.instanceSnapshotName() != null) {
            sb.append("InstanceSnapshotName: ").append(this.instanceSnapshotName()).append(",");
        }
        if (this.bundleId() != null) {
            sb.append("BundleId: ").append(this.bundleId()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (this.keyPairName() != null) {
            sb.append("KeyPairName: ").append(this.keyPairName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceNames": {
                return Optional.of(clazz.cast(this.instanceNames()));
            }
            case "attachedDiskMapping": {
                return Optional.of(clazz.cast(this.attachedDiskMapping()));
            }
            case "availabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "instanceSnapshotName": {
                return Optional.of(clazz.cast(this.instanceSnapshotName()));
            }
            case "bundleId": {
                return Optional.of(clazz.cast(this.bundleId()));
            }
            case "userData": {
                return Optional.of(clazz.cast(this.userData()));
            }
            case "keyPairName": {
                return Optional.of(clazz.cast(this.keyPairName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instanceNames;
        private Map<String, List<DiskMap>> attachedDiskMapping;
        private String availabilityZone;
        private String instanceSnapshotName;
        private String bundleId;
        private String userData;
        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesFromSnapshotRequest model) {
            this.instanceNames(model.instanceNames);
            this.attachedDiskMapping(model.attachedDiskMapping);
            this.availabilityZone(model.availabilityZone);
            this.instanceSnapshotName(model.instanceSnapshotName);
            this.bundleId(model.bundleId);
            this.userData(model.userData);
            this.keyPairName(model.keyPairName);
        }

        public final Collection<String> getInstanceNames() {
            return this.instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        public final Map<String, ? extends Collection<DiskMap>> getAttachedDiskMapping() {
            return this.attachedDiskMapping;
        }

        @Override
        public final Builder attachedDiskMapping(Map<String, ? extends Collection<DiskMap>> attachedDiskMapping) {
            this.attachedDiskMapping = AttachedDiskMapCopier.copy(attachedDiskMapping);
            return this;
        }

        public final void setAttachedDiskMapping(Map<String, ? extends Collection<DiskMap>> attachedDiskMapping) {
            this.attachedDiskMapping = AttachedDiskMapCopier.copy(attachedDiskMapping);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getInstanceSnapshotName() {
            return this.instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        public CreateInstancesFromSnapshotRequest build() {
            return new CreateInstancesFromSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInstancesFromSnapshotRequest> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);

        public Builder attachedDiskMapping(Map<String, ? extends Collection<DiskMap>> var1);

        public Builder availabilityZone(String var1);

        public Builder instanceSnapshotName(String var1);

        public Builder bundleId(String var1);

        public Builder userData(String var1);

        public Builder keyPairName(String var1);
    }
}

