/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.DiskMapMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DiskMap
implements StructuredPojo,
ToCopyableBuilder<Builder, DiskMap> {
    private final String originalDiskPath;
    private final String newDiskName;

    private DiskMap(BuilderImpl builder) {
        this.originalDiskPath = builder.originalDiskPath;
        this.newDiskName = builder.newDiskName;
    }

    public String originalDiskPath() {
        return this.originalDiskPath;
    }

    public String newDiskName() {
        return this.newDiskName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.originalDiskPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.newDiskName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskMap)) {
            return false;
        }
        DiskMap other = (DiskMap)obj;
        return Objects.equals(this.originalDiskPath(), other.originalDiskPath()) && Objects.equals(this.newDiskName(), other.newDiskName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.originalDiskPath() != null) {
            sb.append("OriginalDiskPath: ").append(this.originalDiskPath()).append(",");
        }
        if (this.newDiskName() != null) {
            sb.append("NewDiskName: ").append(this.newDiskName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "originalDiskPath": {
                return Optional.of(clazz.cast(this.originalDiskPath()));
            }
            case "newDiskName": {
                return Optional.of(clazz.cast(this.newDiskName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiskMapMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String originalDiskPath;
        private String newDiskName;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskMap model) {
            this.originalDiskPath(model.originalDiskPath);
            this.newDiskName(model.newDiskName);
        }

        public final String getOriginalDiskPath() {
            return this.originalDiskPath;
        }

        @Override
        public final Builder originalDiskPath(String originalDiskPath) {
            this.originalDiskPath = originalDiskPath;
            return this;
        }

        public final void setOriginalDiskPath(String originalDiskPath) {
            this.originalDiskPath = originalDiskPath;
        }

        public final String getNewDiskName() {
            return this.newDiskName;
        }

        @Override
        public final Builder newDiskName(String newDiskName) {
            this.newDiskName = newDiskName;
            return this;
        }

        public final void setNewDiskName(String newDiskName) {
            this.newDiskName = newDiskName;
        }

        public DiskMap build() {
            return new DiskMap(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DiskMap> {
        public Builder originalDiskPath(String var1);

        public Builder newDiskName(String var1);
    }
}

