/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshot;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshotListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDiskSnapshotsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDiskSnapshotsResponse> {
    private final List<DiskSnapshot> diskSnapshots;
    private final String nextPageToken;

    private GetDiskSnapshotsResponse(BuilderImpl builder) {
        this.diskSnapshots = builder.diskSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<DiskSnapshot> diskSnapshots() {
        return this.diskSnapshots;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSnapshots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiskSnapshotsResponse)) {
            return false;
        }
        GetDiskSnapshotsResponse other = (GetDiskSnapshotsResponse)((Object)obj);
        return Objects.equals(this.diskSnapshots(), other.diskSnapshots()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.diskSnapshots() != null) {
            sb.append("DiskSnapshots: ").append(this.diskSnapshots()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskSnapshots": {
                return Optional.of(clazz.cast(this.diskSnapshots()));
            }
            case "nextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DiskSnapshot> diskSnapshots;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiskSnapshotsResponse model) {
            this.diskSnapshots(model.diskSnapshots);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<DiskSnapshot.Builder> getDiskSnapshots() {
            return this.diskSnapshots != null ? (Collection)this.diskSnapshots.stream().map(DiskSnapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder diskSnapshots(Collection<DiskSnapshot> diskSnapshots) {
            this.diskSnapshots = DiskSnapshotListCopier.copy(diskSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskSnapshots(DiskSnapshot ... diskSnapshots) {
            this.diskSnapshots(Arrays.asList(diskSnapshots));
            return this;
        }

        public final void setDiskSnapshots(Collection<DiskSnapshot.BuilderImpl> diskSnapshots) {
            this.diskSnapshots = DiskSnapshotListCopier.copyFromBuilder(diskSnapshots);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetDiskSnapshotsResponse build() {
            return new GetDiskSnapshotsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDiskSnapshotsResponse> {
        public Builder diskSnapshots(Collection<DiskSnapshot> var1);

        public Builder diskSnapshots(DiskSnapshot ... var1);

        public Builder nextPageToken(String var1);
    }
}

