/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.InstancePortState;
import software.amazon.awssdk.services.lightsail.model.InstancePortStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstancePortStatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetInstancePortStatesResponse> {
    private final List<InstancePortState> portStates;

    private GetInstancePortStatesResponse(BuilderImpl builder) {
        this.portStates = builder.portStates;
    }

    public List<InstancePortState> portStates() {
        return this.portStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.portStates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancePortStatesResponse)) {
            return false;
        }
        GetInstancePortStatesResponse other = (GetInstancePortStatesResponse)((Object)obj);
        return Objects.equals(this.portStates(), other.portStates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.portStates() != null) {
            sb.append("PortStates: ").append(this.portStates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portStates": {
                return Optional.of(clazz.cast(this.portStates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstancePortState> portStates;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancePortStatesResponse model) {
            this.portStates(model.portStates);
        }

        public final Collection<InstancePortState.Builder> getPortStates() {
            return this.portStates != null ? (Collection)this.portStates.stream().map(InstancePortState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portStates(Collection<InstancePortState> portStates) {
            this.portStates = InstancePortStateListCopier.copy(portStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portStates(InstancePortState ... portStates) {
            this.portStates(Arrays.asList(portStates));
            return this;
        }

        public final void setPortStates(Collection<InstancePortState.BuilderImpl> portStates) {
            this.portStates = InstancePortStateListCopier.copyFromBuilder(portStates);
        }

        public GetInstancePortStatesResponse build() {
            return new GetInstancePortStatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInstancePortStatesResponse> {
        public Builder portStates(Collection<InstancePortState> var1);

        public Builder portStates(InstancePortState ... var1);
    }
}

