/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.services.lightsail.model.OperationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOperationsForResourceResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetOperationsForResourceResponse> {
    private final List<Operation> operations;
    private final String nextPageCount;
    private final String nextPageToken;

    private GetOperationsForResourceResponse(BuilderImpl builder) {
        this.operations = builder.operations;
        this.nextPageCount = builder.nextPageCount;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Operation> operations() {
        return this.operations;
    }

    public String nextPageCount() {
        return this.nextPageCount;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsForResourceResponse)) {
            return false;
        }
        GetOperationsForResourceResponse other = (GetOperationsForResourceResponse)((Object)obj);
        return Objects.equals(this.operations(), other.operations()) && Objects.equals(this.nextPageCount(), other.nextPageCount()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.operations() != null) {
            sb.append("Operations: ").append(this.operations()).append(",");
        }
        if (this.nextPageCount() != null) {
            sb.append("NextPageCount: ").append(this.nextPageCount()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operations": {
                return Optional.of(clazz.cast(this.operations()));
            }
            case "nextPageCount": {
                return Optional.of(clazz.cast(this.nextPageCount()));
            }
            case "nextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Operation> operations;
        private String nextPageCount;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsForResourceResponse model) {
            this.operations(model.operations);
            this.nextPageCount(model.nextPageCount);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<Operation.Builder> getOperations() {
            return this.operations != null ? (Collection)this.operations.stream().map(Operation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        public final String getNextPageCount() {
            return this.nextPageCount;
        }

        @Override
        public final Builder nextPageCount(String nextPageCount) {
            this.nextPageCount = nextPageCount;
            return this;
        }

        public final void setNextPageCount(String nextPageCount) {
            this.nextPageCount = nextPageCount;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetOperationsForResourceResponse build() {
            return new GetOperationsForResourceResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetOperationsForResourceResponse> {
        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);

        public Builder nextPageCount(String var1);

        public Builder nextPageToken(String var1);
    }
}

