/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.BlueprintMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a blueprint (a virtual private server image).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Blueprint implements StructuredPojo, ToCopyableBuilder<Blueprint.Builder, Blueprint> {
    private final String blueprintId;

    private final String name;

    private final String group;

    private final String type;

    private final String description;

    private final Boolean isActive;

    private final Integer minPower;

    private final String version;

    private final String versionCode;

    private final String productUrl;

    private final String licenseUrl;

    private final String platform;

    private Blueprint(BuilderImpl builder) {
        this.blueprintId = builder.blueprintId;
        this.name = builder.name;
        this.group = builder.group;
        this.type = builder.type;
        this.description = builder.description;
        this.isActive = builder.isActive;
        this.minPower = builder.minPower;
        this.version = builder.version;
        this.versionCode = builder.versionCode;
        this.productUrl = builder.productUrl;
        this.licenseUrl = builder.licenseUrl;
        this.platform = builder.platform;
    }

    /**
     * <p>
     * The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>).
     * </p>
     * 
     * @return The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
     *         <code>app_lamp_7_0</code>).
     */
    public String blueprintId() {
        return blueprintId;
    }

    /**
     * <p>
     * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     * </p>
     * 
     * @return The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The group name of the blueprint (e.g., <code>amazon-linux</code>).
     * </p>
     * 
     * @return The group name of the blueprint (e.g., <code>amazon-linux</code>).
     */
    public String group() {
        return group;
    }

    /**
     * <p>
     * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BlueprintType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * @see BlueprintType
     */
    public BlueprintType type() {
        return BlueprintType.fromValue(type);
    }

    /**
     * <p>
     * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BlueprintType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * @see BlueprintType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The description of the blueprint.
     * </p>
     * 
     * @return The description of the blueprint.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A Boolean value indicating whether the blueprint is active. When you update your blueprints, you will inactivate
     * old blueprints and keep the most recent versions active.
     * </p>
     * 
     * @return A Boolean value indicating whether the blueprint is active. When you update your blueprints, you will
     *         inactivate old blueprints and keep the most recent versions active.
     */
    public Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * The minimum bundle power required to run this blueprint. For example, you need a bundle with a power value of 500
     * or more to create an instance that uses a blueprint with a minimum power value of 500. <code>0</code> indicates
     * that the blueprint runs on all instance sizes.
     * </p>
     * 
     * @return The minimum bundle power required to run this blueprint. For example, you need a bundle with a power
     *         value of 500 or more to create an instance that uses a blueprint with a minimum power value of 500.
     *         <code>0</code> indicates that the blueprint runs on all instance sizes.
     */
    public Integer minPower() {
        return minPower;
    }

    /**
     * <p>
     * The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
     * </p>
     * 
     * @return The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The version code.
     * </p>
     * 
     * @return The version code.
     */
    public String versionCode() {
        return versionCode;
    }

    /**
     * <p>
     * The product URL to learn more about the image or blueprint.
     * </p>
     * 
     * @return The product URL to learn more about the image or blueprint.
     */
    public String productUrl() {
        return productUrl;
    }

    /**
     * <p>
     * The end-user license agreement URL for the image or blueprint.
     * </p>
     * 
     * @return The end-user license agreement URL for the image or blueprint.
     */
    public String licenseUrl() {
        return licenseUrl;
    }

    /**
     * <p>
     * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link InstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
     * @see InstancePlatform
     */
    public InstancePlatform platform() {
        return InstancePlatform.fromValue(platform);
    }

    /**
     * <p>
     * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link InstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
     * @see InstancePlatform
     */
    public String platformString() {
        return platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        hashCode = 31 * hashCode + Objects.hashCode(minPower());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(versionCode());
        hashCode = 31 * hashCode + Objects.hashCode(productUrl());
        hashCode = 31 * hashCode + Objects.hashCode(licenseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(platformString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint) obj;
        return Objects.equals(blueprintId(), other.blueprintId()) && Objects.equals(name(), other.name())
                && Objects.equals(group(), other.group()) && Objects.equals(typeString(), other.typeString())
                && Objects.equals(description(), other.description()) && Objects.equals(isActive(), other.isActive())
                && Objects.equals(minPower(), other.minPower()) && Objects.equals(version(), other.version())
                && Objects.equals(versionCode(), other.versionCode()) && Objects.equals(productUrl(), other.productUrl())
                && Objects.equals(licenseUrl(), other.licenseUrl()) && Objects.equals(platformString(), other.platformString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (blueprintId() != null) {
            sb.append("BlueprintId: ").append(blueprintId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (group() != null) {
            sb.append("Group: ").append(group()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (isActive() != null) {
            sb.append("IsActive: ").append(isActive()).append(",");
        }
        if (minPower() != null) {
            sb.append("MinPower: ").append(minPower()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (versionCode() != null) {
            sb.append("VersionCode: ").append(versionCode()).append(",");
        }
        if (productUrl() != null) {
            sb.append("ProductUrl: ").append(productUrl()).append(",");
        }
        if (licenseUrl() != null) {
            sb.append("LicenseUrl: ").append(licenseUrl()).append(",");
        }
        if (platformString() != null) {
            sb.append("Platform: ").append(platformString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintId":
            return Optional.of(clazz.cast(blueprintId()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "group":
            return Optional.of(clazz.cast(group()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "description":
            return Optional.of(clazz.cast(description()));
        case "isActive":
            return Optional.of(clazz.cast(isActive()));
        case "minPower":
            return Optional.of(clazz.cast(minPower()));
        case "version":
            return Optional.of(clazz.cast(version()));
        case "versionCode":
            return Optional.of(clazz.cast(versionCode()));
        case "productUrl":
            return Optional.of(clazz.cast(productUrl()));
        case "licenseUrl":
            return Optional.of(clazz.cast(licenseUrl()));
        case "platform":
            return Optional.of(clazz.cast(platformString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlueprintMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Blueprint> {
        /**
         * <p>
         * The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
         * <code>app_lamp_7_0</code>).
         * </p>
         * 
         * @param blueprintId
         *        The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
         *        <code>app_lamp_7_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintId(String blueprintId);

        /**
         * <p>
         * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * </p>
         * 
         * @param name
         *        The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The group name of the blueprint (e.g., <code>amazon-linux</code>).
         * </p>
         * 
         * @param group
         *        The group name of the blueprint (e.g., <code>amazon-linux</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * </p>
         * 
         * @param type
         *        The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * @see BlueprintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * </p>
         * 
         * @param type
         *        The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * @see BlueprintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintType
         */
        Builder type(BlueprintType type);

        /**
         * <p>
         * The description of the blueprint.
         * </p>
         * 
         * @param description
         *        The description of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A Boolean value indicating whether the blueprint is active. When you update your blueprints, you will
         * inactivate old blueprints and keep the most recent versions active.
         * </p>
         * 
         * @param isActive
         *        A Boolean value indicating whether the blueprint is active. When you update your blueprints, you will
         *        inactivate old blueprints and keep the most recent versions active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * The minimum bundle power required to run this blueprint. For example, you need a bundle with a power value of
         * 500 or more to create an instance that uses a blueprint with a minimum power value of 500. <code>0</code>
         * indicates that the blueprint runs on all instance sizes.
         * </p>
         * 
         * @param minPower
         *        The minimum bundle power required to run this blueprint. For example, you need a bundle with a power
         *        value of 500 or more to create an instance that uses a blueprint with a minimum power value of 500.
         *        <code>0</code> indicates that the blueprint runs on all instance sizes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minPower(Integer minPower);

        /**
         * <p>
         * The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
         * </p>
         * 
         * @param version
         *        The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The version code.
         * </p>
         * 
         * @param versionCode
         *        The version code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionCode(String versionCode);

        /**
         * <p>
         * The product URL to learn more about the image or blueprint.
         * </p>
         * 
         * @param productUrl
         *        The product URL to learn more about the image or blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productUrl(String productUrl);

        /**
         * <p>
         * The end-user license agreement URL for the image or blueprint.
         * </p>
         * 
         * @param licenseUrl
         *        The end-user license agreement URL for the image or blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseUrl(String licenseUrl);

        /**
         * <p>
         * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
         * </p>
         * 
         * @param platform
         *        The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
         * @see InstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstancePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
         * </p>
         * 
         * @param platform
         *        The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
         * @see InstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstancePlatform
         */
        Builder platform(InstancePlatform platform);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintId;

        private String name;

        private String group;

        private String type;

        private String description;

        private Boolean isActive;

        private Integer minPower;

        private String version;

        private String versionCode;

        private String productUrl;

        private String licenseUrl;

        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            blueprintId(model.blueprintId);
            name(model.name);
            group(model.group);
            type(model.type);
            description(model.description);
            isActive(model.isActive);
            minPower(model.minPower);
            version(model.version);
            versionCode(model.versionCode);
            productUrl(model.productUrl);
            licenseUrl(model.licenseUrl);
            platform(model.platform);
        }

        public final String getBlueprintId() {
            return blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getGroup() {
            return group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BlueprintType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public final Integer getMinPower() {
            return minPower;
        }

        @Override
        public final Builder minPower(Integer minPower) {
            this.minPower = minPower;
            return this;
        }

        public final void setMinPower(Integer minPower) {
            this.minPower = minPower;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getVersionCode() {
            return versionCode;
        }

        @Override
        public final Builder versionCode(String versionCode) {
            this.versionCode = versionCode;
            return this;
        }

        public final void setVersionCode(String versionCode) {
            this.versionCode = versionCode;
        }

        public final String getProductUrl() {
            return productUrl;
        }

        @Override
        public final Builder productUrl(String productUrl) {
            this.productUrl = productUrl;
            return this;
        }

        public final void setProductUrl(String productUrl) {
            this.productUrl = productUrl;
        }

        public final String getLicenseUrl() {
            return licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(InstancePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public Blueprint build() {
            return new Blueprint(this);
        }
    }
}
