/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.lightsail.transform.BundleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a bundle, which is a set of specs describing your virtual private server (or <i>instance</i>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Bundle implements StructuredPojo, ToCopyableBuilder<Bundle.Builder, Bundle> {
    private final Float price;

    private final Integer cpuCount;

    private final Integer diskSizeInGb;

    private final String bundleId;

    private final String instanceType;

    private final Boolean isActive;

    private final String name;

    private final Integer power;

    private final Float ramSizeInGb;

    private final Integer transferPerMonthInGb;

    private final List<String> supportedPlatforms;

    private Bundle(BuilderImpl builder) {
        this.price = builder.price;
        this.cpuCount = builder.cpuCount;
        this.diskSizeInGb = builder.diskSizeInGb;
        this.bundleId = builder.bundleId;
        this.instanceType = builder.instanceType;
        this.isActive = builder.isActive;
        this.name = builder.name;
        this.power = builder.power;
        this.ramSizeInGb = builder.ramSizeInGb;
        this.transferPerMonthInGb = builder.transferPerMonthInGb;
        this.supportedPlatforms = builder.supportedPlatforms;
    }

    /**
     * <p>
     * The price in US dollars (e.g., <code>5.0</code>).
     * </p>
     * 
     * @return The price in US dollars (e.g., <code>5.0</code>).
     */
    public Float price() {
        return price;
    }

    /**
     * <p>
     * The number of vCPUs included in the bundle (e.g., <code>2</code>).
     * </p>
     * 
     * @return The number of vCPUs included in the bundle (e.g., <code>2</code>).
     */
    public Integer cpuCount() {
        return cpuCount;
    }

    /**
     * <p>
     * The size of the SSD (e.g., <code>30</code>).
     * </p>
     * 
     * @return The size of the SSD (e.g., <code>30</code>).
     */
    public Integer diskSizeInGb() {
        return diskSizeInGb;
    }

    /**
     * <p>
     * The bundle ID (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle ID (e.g., <code>micro_1_0</code>).
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The Amazon EC2 instance type (e.g., <code>t2.micro</code>).
     * </p>
     * 
     * @return The Amazon EC2 instance type (e.g., <code>t2.micro</code>).
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * A Boolean value indicating whether the bundle is active.
     * </p>
     * 
     * @return A Boolean value indicating whether the bundle is active.
     */
    public Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * A friendly name for the bundle (e.g., <code>Micro</code>).
     * </p>
     * 
     * @return A friendly name for the bundle (e.g., <code>Micro</code>).
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A numeric value that represents the power of the bundle (e.g., <code>500</code>). You can use the bundle's power
     * value in conjunction with a blueprint's minimum power value to determine whether the blueprint will run on the
     * bundle. For example, you need a bundle with a power value of 500 or more to create an instance that uses a
     * blueprint with a minimum power value of 500.
     * </p>
     * 
     * @return A numeric value that represents the power of the bundle (e.g., <code>500</code>). You can use the
     *         bundle's power value in conjunction with a blueprint's minimum power value to determine whether the
     *         blueprint will run on the bundle. For example, you need a bundle with a power value of 500 or more to
     *         create an instance that uses a blueprint with a minimum power value of 500.
     */
    public Integer power() {
        return power;
    }

    /**
     * <p>
     * The amount of RAM in GB (e.g., <code>2.0</code>).
     * </p>
     * 
     * @return The amount of RAM in GB (e.g., <code>2.0</code>).
     */
    public Float ramSizeInGb() {
        return ramSizeInGb;
    }

    /**
     * <p>
     * The data transfer rate per month in GB (e.g., <code>2000</code>).
     * </p>
     * 
     * @return The data transfer rate per month in GB (e.g., <code>2000</code>).
     */
    public Integer transferPerMonthInGb() {
        return transferPerMonthInGb;
    }

    /**
     * <p>
     * The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You can only
     * launch a <code>WINDOWS</code> bundle on a blueprint that supports the <code>WINDOWS</code> platform.
     * <code>LINUX_UNIX</code> blueprints require a <code>LINUX_UNIX</code> bundle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You
     *         can only launch a <code>WINDOWS</code> bundle on a blueprint that supports the <code>WINDOWS</code>
     *         platform. <code>LINUX_UNIX</code> blueprints require a <code>LINUX_UNIX</code> bundle.
     */
    public List<InstancePlatform> supportedPlatforms() {
        return TypeConverter.convert(supportedPlatforms, InstancePlatform::fromValue);
    }

    /**
     * <p>
     * The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You can only
     * launch a <code>WINDOWS</code> bundle on a blueprint that supports the <code>WINDOWS</code> platform.
     * <code>LINUX_UNIX</code> blueprints require a <code>LINUX_UNIX</code> bundle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You
     *         can only launch a <code>WINDOWS</code> bundle on a blueprint that supports the <code>WINDOWS</code>
     *         platform. <code>LINUX_UNIX</code> blueprints require a <code>LINUX_UNIX</code> bundle.
     */
    public List<String> supportedPlatformsStrings() {
        return supportedPlatforms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(price());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(diskSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(power());
        hashCode = 31 * hashCode + Objects.hashCode(ramSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(transferPerMonthInGb());
        hashCode = 31 * hashCode + Objects.hashCode(supportedPlatformsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bundle)) {
            return false;
        }
        Bundle other = (Bundle) obj;
        return Objects.equals(price(), other.price()) && Objects.equals(cpuCount(), other.cpuCount())
                && Objects.equals(diskSizeInGb(), other.diskSizeInGb()) && Objects.equals(bundleId(), other.bundleId())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(isActive(), other.isActive())
                && Objects.equals(name(), other.name()) && Objects.equals(power(), other.power())
                && Objects.equals(ramSizeInGb(), other.ramSizeInGb())
                && Objects.equals(transferPerMonthInGb(), other.transferPerMonthInGb())
                && Objects.equals(supportedPlatformsStrings(), other.supportedPlatformsStrings());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (price() != null) {
            sb.append("Price: ").append(price()).append(",");
        }
        if (cpuCount() != null) {
            sb.append("CpuCount: ").append(cpuCount()).append(",");
        }
        if (diskSizeInGb() != null) {
            sb.append("DiskSizeInGb: ").append(diskSizeInGb()).append(",");
        }
        if (bundleId() != null) {
            sb.append("BundleId: ").append(bundleId()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (isActive() != null) {
            sb.append("IsActive: ").append(isActive()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (power() != null) {
            sb.append("Power: ").append(power()).append(",");
        }
        if (ramSizeInGb() != null) {
            sb.append("RamSizeInGb: ").append(ramSizeInGb()).append(",");
        }
        if (transferPerMonthInGb() != null) {
            sb.append("TransferPerMonthInGb: ").append(transferPerMonthInGb()).append(",");
        }
        if (supportedPlatformsStrings() != null) {
            sb.append("SupportedPlatforms: ").append(supportedPlatformsStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "price":
            return Optional.of(clazz.cast(price()));
        case "cpuCount":
            return Optional.of(clazz.cast(cpuCount()));
        case "diskSizeInGb":
            return Optional.of(clazz.cast(diskSizeInGb()));
        case "bundleId":
            return Optional.of(clazz.cast(bundleId()));
        case "instanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "isActive":
            return Optional.of(clazz.cast(isActive()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "power":
            return Optional.of(clazz.cast(power()));
        case "ramSizeInGb":
            return Optional.of(clazz.cast(ramSizeInGb()));
        case "transferPerMonthInGb":
            return Optional.of(clazz.cast(transferPerMonthInGb()));
        case "supportedPlatforms":
            return Optional.of(clazz.cast(supportedPlatformsStrings()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BundleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Bundle> {
        /**
         * <p>
         * The price in US dollars (e.g., <code>5.0</code>).
         * </p>
         * 
         * @param price
         *        The price in US dollars (e.g., <code>5.0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Float price);

        /**
         * <p>
         * The number of vCPUs included in the bundle (e.g., <code>2</code>).
         * </p>
         * 
         * @param cpuCount
         *        The number of vCPUs included in the bundle (e.g., <code>2</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCount(Integer cpuCount);

        /**
         * <p>
         * The size of the SSD (e.g., <code>30</code>).
         * </p>
         * 
         * @param diskSizeInGb
         *        The size of the SSD (e.g., <code>30</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSizeInGb(Integer diskSizeInGb);

        /**
         * <p>
         * The bundle ID (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle ID (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The Amazon EC2 instance type (e.g., <code>t2.micro</code>).
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type (e.g., <code>t2.micro</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * A Boolean value indicating whether the bundle is active.
         * </p>
         * 
         * @param isActive
         *        A Boolean value indicating whether the bundle is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * A friendly name for the bundle (e.g., <code>Micro</code>).
         * </p>
         * 
         * @param name
         *        A friendly name for the bundle (e.g., <code>Micro</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A numeric value that represents the power of the bundle (e.g., <code>500</code>). You can use the bundle's
         * power value in conjunction with a blueprint's minimum power value to determine whether the blueprint will run
         * on the bundle. For example, you need a bundle with a power value of 500 or more to create an instance that
         * uses a blueprint with a minimum power value of 500.
         * </p>
         * 
         * @param power
         *        A numeric value that represents the power of the bundle (e.g., <code>500</code>). You can use the
         *        bundle's power value in conjunction with a blueprint's minimum power value to determine whether the
         *        blueprint will run on the bundle. For example, you need a bundle with a power value of 500 or more to
         *        create an instance that uses a blueprint with a minimum power value of 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder power(Integer power);

        /**
         * <p>
         * The amount of RAM in GB (e.g., <code>2.0</code>).
         * </p>
         * 
         * @param ramSizeInGb
         *        The amount of RAM in GB (e.g., <code>2.0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramSizeInGb(Float ramSizeInGb);

        /**
         * <p>
         * The data transfer rate per month in GB (e.g., <code>2000</code>).
         * </p>
         * 
         * @param transferPerMonthInGb
         *        The data transfer rate per month in GB (e.g., <code>2000</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferPerMonthInGb(Integer transferPerMonthInGb);

        /**
         * <p>
         * The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You can
         * only launch a <code>WINDOWS</code> bundle on a blueprint that supports the <code>WINDOWS</code> platform.
         * <code>LINUX_UNIX</code> blueprints require a <code>LINUX_UNIX</code> bundle.
         * </p>
         * 
         * @param supportedPlatforms
         *        The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You
         *        can only launch a <code>WINDOWS</code> bundle on a blueprint that supports the <code>WINDOWS</code>
         *        platform. <code>LINUX_UNIX</code> blueprints require a <code>LINUX_UNIX</code> bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPlatforms(Collection<String> supportedPlatforms);

        /**
         * <p>
         * The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You can
         * only launch a <code>WINDOWS</code> bundle on a blueprint that supports the <code>WINDOWS</code> platform.
         * <code>LINUX_UNIX</code> blueprints require a <code>LINUX_UNIX</code> bundle.
         * </p>
         * 
         * @param supportedPlatforms
         *        The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle supports. You
         *        can only launch a <code>WINDOWS</code> bundle on a blueprint that supports the <code>WINDOWS</code>
         *        platform. <code>LINUX_UNIX</code> blueprints require a <code>LINUX_UNIX</code> bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPlatforms(String... supportedPlatforms);
    }

    static final class BuilderImpl implements Builder {
        private Float price;

        private Integer cpuCount;

        private Integer diskSizeInGb;

        private String bundleId;

        private String instanceType;

        private Boolean isActive;

        private String name;

        private Integer power;

        private Float ramSizeInGb;

        private Integer transferPerMonthInGb;

        private List<String> supportedPlatforms;

        private BuilderImpl() {
        }

        private BuilderImpl(Bundle model) {
            price(model.price);
            cpuCount(model.cpuCount);
            diskSizeInGb(model.diskSizeInGb);
            bundleId(model.bundleId);
            instanceType(model.instanceType);
            isActive(model.isActive);
            name(model.name);
            power(model.power);
            ramSizeInGb(model.ramSizeInGb);
            transferPerMonthInGb(model.transferPerMonthInGb);
            supportedPlatforms(model.supportedPlatforms);
        }

        public final Float getPrice() {
            return price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        public final Integer getCpuCount() {
            return cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Integer getDiskSizeInGb() {
            return diskSizeInGb;
        }

        @Override
        public final Builder diskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
            return this;
        }

        public final void setDiskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPower() {
            return power;
        }

        @Override
        public final Builder power(Integer power) {
            this.power = power;
            return this;
        }

        public final void setPower(Integer power) {
            this.power = power;
        }

        public final Float getRamSizeInGb() {
            return ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public final Integer getTransferPerMonthInGb() {
            return transferPerMonthInGb;
        }

        @Override
        public final Builder transferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
            return this;
        }

        public final void setTransferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
        }

        public final Collection<String> getSupportedPlatforms() {
            return supportedPlatforms;
        }

        @Override
        public final Builder supportedPlatforms(Collection<String> supportedPlatforms) {
            this.supportedPlatforms = InstancePlatformListCopier.copy(supportedPlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPlatforms(String... supportedPlatforms) {
            supportedPlatforms(Arrays.asList(supportedPlatforms));
            return this;
        }

        public final void setSupportedPlatforms(Collection<String> supportedPlatforms) {
            this.supportedPlatforms = InstancePlatformListCopier.copy(supportedPlatforms);
        }

        @Override
        public Bundle build() {
            return new Bundle(this);
        }
    }
}
