/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDiskRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateDiskRequest.Builder, CreateDiskRequest> {
    private final String diskName;

    private final String availabilityZone;

    private final Integer sizeInGb;

    private CreateDiskRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.availabilityZone = builder.availabilityZone;
        this.sizeInGb = builder.sizeInGb;
    }

    /**
     * <p>
     * The unique Lightsail disk name (e.g., <code>my-disk</code>).
     * </p>
     * 
     * @return The unique Lightsail disk name (e.g., <code>my-disk</code>).
     */
    public String diskName() {
        return diskName;
    }

    /**
     * <p>
     * The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same
     * Availability Zone as the Lightsail instance where you want to create the disk.
     * </p>
     * <p>
     * Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
     * </p>
     * 
     * @return The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same
     *         Availability Zone as the Lightsail instance where you want to create the disk.</p>
     *         <p>
     *         Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The size of the disk in GB (e.g., <code>32</code>).
     * </p>
     * 
     * @return The size of the disk in GB (e.g., <code>32</code>).
     */
    public Integer sizeInGb() {
        return sizeInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(diskName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGb());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskRequest)) {
            return false;
        }
        CreateDiskRequest other = (CreateDiskRequest) obj;
        return Objects.equals(diskName(), other.diskName()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(sizeInGb(), other.sizeInGb());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (diskName() != null) {
            sb.append("DiskName: ").append(diskName()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (sizeInGb() != null) {
            sb.append("SizeInGb: ").append(sizeInGb()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskName":
            return Optional.of(clazz.cast(diskName()));
        case "availabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "sizeInGb":
            return Optional.of(clazz.cast(sizeInGb()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, CreateDiskRequest> {
        /**
         * <p>
         * The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * </p>
         * 
         * @param diskName
         *        The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskName(String diskName);

        /**
         * <p>
         * The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same
         * Availability Zone as the Lightsail instance where you want to create the disk.
         * </p>
         * <p>
         * Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the
         *        same Availability Zone as the Lightsail instance where you want to create the disk.</p>
         *        <p>
         *        Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The size of the disk in GB (e.g., <code>32</code>).
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB (e.g., <code>32</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskName;

        private String availabilityZone;

        private Integer sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskRequest model) {
            diskName(model.diskName);
            availabilityZone(model.availabilityZone);
            sizeInGb(model.sizeInGb);
        }

        public final String getDiskName() {
            return diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDiskRequest build() {
            return new CreateDiskRequest(this);
        }
    }
}
