/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDomainEntryRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateDomainEntryRequest.Builder, CreateDomainEntryRequest> {
    private final String domainName;

    private final DomainEntry domainEntry;

    private CreateDomainEntryRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainEntry = builder.domainEntry;
    }

    /**
     * <p>
     * The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.
     * </p>
     * 
     * @return The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the domain entry request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the domain entry request.
     */
    public DomainEntry domainEntry() {
        return domainEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainEntry());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainEntryRequest)) {
            return false;
        }
        CreateDomainEntryRequest other = (CreateDomainEntryRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(domainEntry(), other.domainEntry());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (domainEntry() != null) {
            sb.append("DomainEntry: ").append(domainEntry()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.of(clazz.cast(domainName()));
        case "domainEntry":
            return Optional.of(clazz.cast(domainEntry()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, CreateDomainEntryRequest> {
        /**
         * <p>
         * The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.
         * </p>
         * 
         * @param domainName
         *        The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * An array of key-value pairs containing information about the domain entry request.
         * </p>
         * 
         * @param domainEntry
         *        An array of key-value pairs containing information about the domain entry request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEntry(DomainEntry domainEntry);

        /**
         * <p>
         * An array of key-value pairs containing information about the domain entry request.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainEntry.Builder} avoiding the need to create
         * one manually via {@link DomainEntry#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainEntry.Builder#build()} is called immediately and its result
         * is passed to {@link #domainEntry(DomainEntry)}.
         * 
         * @param domainEntry
         *        a consumer that will call methods on {@link DomainEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEntry(DomainEntry)
         */
        default Builder domainEntry(Consumer<DomainEntry.Builder> domainEntry) {
            return domainEntry(DomainEntry.builder().apply(domainEntry).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String domainName;

        private DomainEntry domainEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainEntryRequest model) {
            domainName(model.domainName);
            domainEntry(model.domainEntry);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final DomainEntry.Builder getDomainEntry() {
            return domainEntry != null ? domainEntry.toBuilder() : null;
        }

        @Override
        public final Builder domainEntry(DomainEntry domainEntry) {
            this.domainEntry = domainEntry;
            return this;
        }

        public final void setDomainEntry(DomainEntry.BuilderImpl domainEntry) {
            this.domainEntry = domainEntry != null ? domainEntry.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainEntryRequest build() {
            return new CreateDomainEntryRequest(this);
        }
    }
}
