/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInstanceSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateInstanceSnapshotRequest.Builder, CreateInstanceSnapshotRequest> {
    private final String instanceSnapshotName;

    private final String instanceName;

    private CreateInstanceSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.instanceName = builder.instanceName;
    }

    /**
     * <p>
     * The name for your new snapshot.
     * </p>
     * 
     * @return The name for your new snapshot.
     */
    public String instanceSnapshotName() {
        return instanceSnapshotName;
    }

    /**
     * <p>
     * The Lightsail instance on which to base your snapshot.
     * </p>
     * 
     * @return The Lightsail instance on which to base your snapshot.
     */
    public String instanceName() {
        return instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceSnapshotRequest)) {
            return false;
        }
        CreateInstanceSnapshotRequest other = (CreateInstanceSnapshotRequest) obj;
        return Objects.equals(instanceSnapshotName(), other.instanceSnapshotName())
                && Objects.equals(instanceName(), other.instanceName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceSnapshotName() != null) {
            sb.append("InstanceSnapshotName: ").append(instanceSnapshotName()).append(",");
        }
        if (instanceName() != null) {
            sb.append("InstanceName: ").append(instanceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceSnapshotName":
            return Optional.of(clazz.cast(instanceSnapshotName()));
        case "instanceName":
            return Optional.of(clazz.cast(instanceName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, CreateInstanceSnapshotRequest> {
        /**
         * <p>
         * The name for your new snapshot.
         * </p>
         * 
         * @param instanceSnapshotName
         *        The name for your new snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshotName(String instanceSnapshotName);

        /**
         * <p>
         * The Lightsail instance on which to base your snapshot.
         * </p>
         * 
         * @param instanceName
         *        The Lightsail instance on which to base your snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String instanceSnapshotName;

        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceSnapshotRequest model) {
            instanceSnapshotName(model.instanceSnapshotName);
            instanceName(model.instanceName);
        }

        public final String getInstanceSnapshotName() {
            return instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceSnapshotRequest build() {
            return new CreateInstanceSnapshotRequest(this);
        }
    }
}
