/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInstancesResponse extends LightsailResponse implements
        ToCopyableBuilder<CreateInstancesResponse.Builder, CreateInstancesResponse> {
    private final List<Operation> operations;

    private CreateInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your create instances request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your create instances request.
     */
    public List<Operation> operations() {
        return operations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesResponse)) {
            return false;
        }
        CreateInstancesResponse other = (CreateInstancesResponse) obj;
        return Objects.equals(operations(), other.operations());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (operations() != null) {
            sb.append("Operations: ").append(operations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operations":
            return Optional.of(clazz.cast(operations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, CreateInstancesResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your create instances request.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your create instances request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your create instances request.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your create instances request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Operation> operations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesResponse model) {
            operations(model.operations);
        }

        public final Collection<Operation.Builder> getOperations() {
            return operations != null ? operations.stream().map(Operation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        @Override
        public CreateInstancesResponse build() {
            return new CreateInstancesResponse(this);
        }
    }
}
